package zio.aws.route53resolver.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.route53resolver.model.primitives.{
  ResolverQueryLogConfigName,
  CreatorRequestId,
  AccountId,
  Count,
  Arn,
  Rfc3339TimeString,
  DestinationArn,
  ResourceId
}
import scala.jdk.CollectionConverters._
final case class ResolverQueryLogConfig(
    id: Option[ResourceId] = None,
    ownerId: Option[AccountId] = None,
    status: Option[zio.aws.route53resolver.model.ResolverQueryLogConfigStatus] =
      None,
    shareStatus: Option[zio.aws.route53resolver.model.ShareStatus] = None,
    associationCount: Option[Count] = None,
    arn: Option[Arn] = None,
    name: Option[ResolverQueryLogConfigName] = None,
    destinationArn: Option[DestinationArn] = None,
    creatorRequestId: Option[CreatorRequestId] = None,
    creationTime: Option[Rfc3339TimeString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.ResolverQueryLogConfig = {
    import ResolverQueryLogConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.ResolverQueryLogConfig
      .builder()
      .optionallyWith(
        id.map(value => ResourceId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        ownerId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.ownerId)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(shareStatus.map(value => value.unwrap))(_.shareStatus)
      .optionallyWith(
        associationCount.map(value => Count.unwrap(value): Integer)
      )(_.associationCount)
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(
        name.map(value =>
          ResolverQueryLogConfigName.unwrap(value): java.lang.String
        )
      )(_.name)
      .optionallyWith(
        destinationArn.map(value =>
          DestinationArn.unwrap(value): java.lang.String
        )
      )(_.destinationArn)
      .optionallyWith(
        creatorRequestId.map(value =>
          CreatorRequestId.unwrap(value): java.lang.String
        )
      )(_.creatorRequestId)
      .optionallyWith(
        creationTime.map(value =>
          Rfc3339TimeString.unwrap(value): java.lang.String
        )
      )(_.creationTime)
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.ResolverQueryLogConfig.ReadOnly =
    zio.aws.route53resolver.model.ResolverQueryLogConfig.wrap(buildAwsValue())
}
object ResolverQueryLogConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.ResolverQueryLogConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53resolver.model.ResolverQueryLogConfig =
      zio.aws.route53resolver.model.ResolverQueryLogConfig(
        id.map(value => value),
        ownerId.map(value => value),
        status.map(value => value),
        shareStatus.map(value => value),
        associationCount.map(value => value),
        arn.map(value => value),
        name.map(value => value),
        destinationArn.map(value => value),
        creatorRequestId.map(value => value),
        creationTime.map(value => value)
      )
    def id: Option[ResourceId]
    def ownerId: Option[AccountId]
    def status
        : Option[zio.aws.route53resolver.model.ResolverQueryLogConfigStatus]
    def shareStatus: Option[zio.aws.route53resolver.model.ShareStatus]
    def associationCount: Option[Count]
    def arn: Option[Arn]
    def name: Option[ResolverQueryLogConfigName]
    def destinationArn: Option[DestinationArn]
    def creatorRequestId: Option[CreatorRequestId]
    def creationTime: Option[Rfc3339TimeString]
    def getId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("id", id)
    def getOwnerId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("ownerId", ownerId)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.route53resolver.model.ResolverQueryLogConfigStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getShareStatus
        : ZIO[Any, AwsError, zio.aws.route53resolver.model.ShareStatus] =
      AwsError.unwrapOptionField("shareStatus", shareStatus)
    def getAssociationCount: ZIO[Any, AwsError, Count] =
      AwsError.unwrapOptionField("associationCount", associationCount)
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, ResolverQueryLogConfigName] =
      AwsError.unwrapOptionField("name", name)
    def getDestinationArn: ZIO[Any, AwsError, DestinationArn] =
      AwsError.unwrapOptionField("destinationArn", destinationArn)
    def getCreatorRequestId: ZIO[Any, AwsError, CreatorRequestId] =
      AwsError.unwrapOptionField("creatorRequestId", creatorRequestId)
    def getCreationTime: ZIO[Any, AwsError, Rfc3339TimeString] =
      AwsError.unwrapOptionField("creationTime", creationTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.ResolverQueryLogConfig
  ) extends zio.aws.route53resolver.model.ResolverQueryLogConfig.ReadOnly {
    override val id: Option[ResourceId] = scala
      .Option(impl.id())
      .map(value => zio.aws.route53resolver.model.primitives.ResourceId(value))
    override val ownerId: Option[AccountId] = scala
      .Option(impl.ownerId())
      .map(value => zio.aws.route53resolver.model.primitives.AccountId(value))
    override val status
        : Option[zio.aws.route53resolver.model.ResolverQueryLogConfigStatus] =
      scala
        .Option(impl.status())
        .map(value =>
          zio.aws.route53resolver.model.ResolverQueryLogConfigStatus.wrap(value)
        )
    override val shareStatus
        : Option[zio.aws.route53resolver.model.ShareStatus] = scala
      .Option(impl.shareStatus())
      .map(value => zio.aws.route53resolver.model.ShareStatus.wrap(value))
    override val associationCount: Option[Count] = scala
      .Option(impl.associationCount())
      .map(value => zio.aws.route53resolver.model.primitives.Count(value))
    override val arn: Option[Arn] = scala
      .Option(impl.arn())
      .map(value => zio.aws.route53resolver.model.primitives.Arn(value))
    override val name: Option[ResolverQueryLogConfigName] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.route53resolver.model.primitives
          .ResolverQueryLogConfigName(value)
      )
    override val destinationArn: Option[DestinationArn] = scala
      .Option(impl.destinationArn())
      .map(value =>
        zio.aws.route53resolver.model.primitives.DestinationArn(value)
      )
    override val creatorRequestId: Option[CreatorRequestId] = scala
      .Option(impl.creatorRequestId())
      .map(value =>
        zio.aws.route53resolver.model.primitives.CreatorRequestId(value)
      )
    override val creationTime: Option[Rfc3339TimeString] = scala
      .Option(impl.creationTime())
      .map(value =>
        zio.aws.route53resolver.model.primitives.Rfc3339TimeString(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.ResolverQueryLogConfig
  ): zio.aws.route53resolver.model.ResolverQueryLogConfig.ReadOnly =
    new Wrapper(impl)
}
