package zio.aws.route53resolver.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.route53resolver.model.primitives.{
  StatusMessage,
  Name,
  ResourceId
}
import scala.jdk.CollectionConverters._
final case class ResolverRuleAssociation(
    id: Option[ResourceId] = None,
    resolverRuleId: Option[ResourceId] = None,
    name: Option[Name] = None,
    vpcId: Option[ResourceId] = None,
    status: Option[
      zio.aws.route53resolver.model.ResolverRuleAssociationStatus
    ] = None,
    statusMessage: Option[StatusMessage] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.ResolverRuleAssociation = {
    import ResolverRuleAssociation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.ResolverRuleAssociation
      .builder()
      .optionallyWith(
        id.map(value => ResourceId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        resolverRuleId.map(value => ResourceId.unwrap(value): java.lang.String)
      )(_.resolverRuleId)
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        vpcId.map(value => ResourceId.unwrap(value): java.lang.String)
      )(_.vpcId)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        statusMessage.map(value =>
          StatusMessage.unwrap(value): java.lang.String
        )
      )(_.statusMessage)
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.ResolverRuleAssociation.ReadOnly =
    zio.aws.route53resolver.model.ResolverRuleAssociation.wrap(buildAwsValue())
}
object ResolverRuleAssociation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.ResolverRuleAssociation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53resolver.model.ResolverRuleAssociation =
      zio.aws.route53resolver.model.ResolverRuleAssociation(
        id.map(value => value),
        resolverRuleId.map(value => value),
        name.map(value => value),
        vpcId.map(value => value),
        status.map(value => value),
        statusMessage.map(value => value)
      )
    def id: Option[ResourceId]
    def resolverRuleId: Option[ResourceId]
    def name: Option[Name]
    def vpcId: Option[ResourceId]
    def status
        : Option[zio.aws.route53resolver.model.ResolverRuleAssociationStatus]
    def statusMessage: Option[StatusMessage]
    def getId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("id", id)
    def getResolverRuleId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("resolverRuleId", resolverRuleId)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getVpcId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.route53resolver.model.ResolverRuleAssociationStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getStatusMessage: ZIO[Any, AwsError, StatusMessage] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.ResolverRuleAssociation
  ) extends zio.aws.route53resolver.model.ResolverRuleAssociation.ReadOnly {
    override val id: Option[ResourceId] = scala
      .Option(impl.id())
      .map(value => zio.aws.route53resolver.model.primitives.ResourceId(value))
    override val resolverRuleId: Option[ResourceId] = scala
      .Option(impl.resolverRuleId())
      .map(value => zio.aws.route53resolver.model.primitives.ResourceId(value))
    override val name: Option[Name] = scala
      .Option(impl.name())
      .map(value => zio.aws.route53resolver.model.primitives.Name(value))
    override val vpcId: Option[ResourceId] = scala
      .Option(impl.vpcId())
      .map(value => zio.aws.route53resolver.model.primitives.ResourceId(value))
    override val status
        : Option[zio.aws.route53resolver.model.ResolverRuleAssociationStatus] =
      scala
        .Option(impl.status())
        .map(value =>
          zio.aws.route53resolver.model.ResolverRuleAssociationStatus
            .wrap(value)
        )
    override val statusMessage: Option[StatusMessage] = scala
      .Option(impl.statusMessage())
      .map(value =>
        zio.aws.route53resolver.model.primitives.StatusMessage(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.ResolverRuleAssociation
  ): zio.aws.route53resolver.model.ResolverRuleAssociation.ReadOnly =
    new Wrapper(impl)
}
