package zio.aws.route53resolver.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.route53resolver.model.primitives.{AccountId, ResourceId}
import scala.jdk.CollectionConverters._
final case class ResolverDnssecConfig(
    id: Option[ResourceId] = None,
    ownerId: Option[AccountId] = None,
    resourceId: Option[ResourceId] = None,
    validationStatus: Option[
      zio.aws.route53resolver.model.ResolverDNSSECValidationStatus
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.ResolverDnssecConfig = {
    import ResolverDnssecConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.ResolverDnssecConfig
      .builder()
      .optionallyWith(
        id.map(value => ResourceId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        ownerId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.ownerId)
      .optionallyWith(
        resourceId.map(value => ResourceId.unwrap(value): java.lang.String)
      )(_.resourceId)
      .optionallyWith(validationStatus.map(value => value.unwrap))(
        _.validationStatus
      )
      .build()
  }
  def asReadOnly: zio.aws.route53resolver.model.ResolverDnssecConfig.ReadOnly =
    zio.aws.route53resolver.model.ResolverDnssecConfig.wrap(buildAwsValue())
}
object ResolverDnssecConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.ResolverDnssecConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53resolver.model.ResolverDnssecConfig =
      zio.aws.route53resolver.model.ResolverDnssecConfig(
        id.map(value => value),
        ownerId.map(value => value),
        resourceId.map(value => value),
        validationStatus.map(value => value)
      )
    def id: Option[ResourceId]
    def ownerId: Option[AccountId]
    def resourceId: Option[ResourceId]
    def validationStatus
        : Option[zio.aws.route53resolver.model.ResolverDNSSECValidationStatus]
    def getId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("id", id)
    def getOwnerId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("ownerId", ownerId)
    def getResourceId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("resourceId", resourceId)
    def getValidationStatus: ZIO[
      Any,
      AwsError,
      zio.aws.route53resolver.model.ResolverDNSSECValidationStatus
    ] = AwsError.unwrapOptionField("validationStatus", validationStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.ResolverDnssecConfig
  ) extends zio.aws.route53resolver.model.ResolverDnssecConfig.ReadOnly {
    override val id: Option[ResourceId] = scala
      .Option(impl.id())
      .map(value => zio.aws.route53resolver.model.primitives.ResourceId(value))
    override val ownerId: Option[AccountId] = scala
      .Option(impl.ownerId())
      .map(value => zio.aws.route53resolver.model.primitives.AccountId(value))
    override val resourceId: Option[ResourceId] = scala
      .Option(impl.resourceId())
      .map(value => zio.aws.route53resolver.model.primitives.ResourceId(value))
    override val validationStatus
        : Option[zio.aws.route53resolver.model.ResolverDNSSECValidationStatus] =
      scala
        .Option(impl.validationStatus())
        .map(value =>
          zio.aws.route53resolver.model.ResolverDNSSECValidationStatus
            .wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.ResolverDnssecConfig
  ): zio.aws.route53resolver.model.ResolverDnssecConfig.ReadOnly = new Wrapper(
    impl
  )
}
