package zio.aws.route53resolver.model
import scala.jdk.CollectionConverters._
sealed trait ShareStatus {
  def unwrap: software.amazon.awssdk.services.route53resolver.model.ShareStatus
}
object ShareStatus {
  def wrap(
      value: software.amazon.awssdk.services.route53resolver.model.ShareStatus
  ): zio.aws.route53resolver.model.ShareStatus = value match {
    case software.amazon.awssdk.services.route53resolver.model.ShareStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.route53resolver.model.ShareStatus.NOT_SHARED =>
      val r = NOT_SHARED
      r
    case software.amazon.awssdk.services.route53resolver.model.ShareStatus.SHARED_WITH_ME =>
      val r = SHARED_WITH_ME
      r
    case software.amazon.awssdk.services.route53resolver.model.ShareStatus.SHARED_BY_ME =>
      val r = SHARED_BY_ME
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.route53resolver.model.ShareStatus {
    override def unwrap
        : software.amazon.awssdk.services.route53resolver.model.ShareStatus =
      software.amazon.awssdk.services.route53resolver.model.ShareStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object NOT_SHARED extends zio.aws.route53resolver.model.ShareStatus {
    override def unwrap
        : software.amazon.awssdk.services.route53resolver.model.ShareStatus =
      software.amazon.awssdk.services.route53resolver.model.ShareStatus.NOT_SHARED
  }
  case object SHARED_WITH_ME extends zio.aws.route53resolver.model.ShareStatus {
    override def unwrap
        : software.amazon.awssdk.services.route53resolver.model.ShareStatus =
      software.amazon.awssdk.services.route53resolver.model.ShareStatus.SHARED_WITH_ME
  }
  case object SHARED_BY_ME extends zio.aws.route53resolver.model.ShareStatus {
    override def unwrap
        : software.amazon.awssdk.services.route53resolver.model.ShareStatus =
      software.amazon.awssdk.services.route53resolver.model.ShareStatus.SHARED_BY_ME
  }
}
