package zio.aws.route53resolver.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.route53resolver.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListResolverConfigsResponse(
    nextToken: Option[NextToken] = None,
    resolverConfigs: Option[
      Iterable[zio.aws.route53resolver.model.ResolverConfig]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.ListResolverConfigsResponse = {
    import ListResolverConfigsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.ListResolverConfigsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        resolverConfigs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resolverConfigs)
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.ListResolverConfigsResponse.ReadOnly =
    zio.aws.route53resolver.model.ListResolverConfigsResponse
      .wrap(buildAwsValue())
}
object ListResolverConfigsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.ListResolverConfigsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53resolver.model.ListResolverConfigsResponse =
      zio.aws.route53resolver.model.ListResolverConfigsResponse(
        nextToken.map(value => value),
        resolverConfigs.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Option[NextToken]
    def resolverConfigs
        : Option[List[zio.aws.route53resolver.model.ResolverConfig.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getResolverConfigs: ZIO[Any, AwsError, List[
      zio.aws.route53resolver.model.ResolverConfig.ReadOnly
    ]] = AwsError.unwrapOptionField("resolverConfigs", resolverConfigs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.ListResolverConfigsResponse
  ) extends zio.aws.route53resolver.model.ListResolverConfigsResponse.ReadOnly {
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.route53resolver.model.primitives.NextToken(value))
    override val resolverConfigs
        : Option[List[zio.aws.route53resolver.model.ResolverConfig.ReadOnly]] =
      scala
        .Option(impl.resolverConfigs())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.route53resolver.model.ResolverConfig.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.ListResolverConfigsResponse
  ): zio.aws.route53resolver.model.ListResolverConfigsResponse.ReadOnly =
    new Wrapper(impl)
}
