package zio.aws.route53resolver.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeleteResolverQueryLogConfigResponse(
    resolverQueryLogConfig: Option[
      zio.aws.route53resolver.model.ResolverQueryLogConfig
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.DeleteResolverQueryLogConfigResponse = {
    import DeleteResolverQueryLogConfigResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.DeleteResolverQueryLogConfigResponse
      .builder()
      .optionallyWith(
        resolverQueryLogConfig.map(value => value.buildAwsValue())
      )(_.resolverQueryLogConfig)
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.DeleteResolverQueryLogConfigResponse.ReadOnly =
    zio.aws.route53resolver.model.DeleteResolverQueryLogConfigResponse
      .wrap(buildAwsValue())
}
object DeleteResolverQueryLogConfigResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.DeleteResolverQueryLogConfigResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.route53resolver.model.DeleteResolverQueryLogConfigResponse =
      zio.aws.route53resolver.model.DeleteResolverQueryLogConfigResponse(
        resolverQueryLogConfig.map(value => value.asEditable)
      )
    def resolverQueryLogConfig
        : Option[zio.aws.route53resolver.model.ResolverQueryLogConfig.ReadOnly]
    def getResolverQueryLogConfig: ZIO[
      Any,
      AwsError,
      zio.aws.route53resolver.model.ResolverQueryLogConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "resolverQueryLogConfig",
      resolverQueryLogConfig
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.DeleteResolverQueryLogConfigResponse
  ) extends zio.aws.route53resolver.model.DeleteResolverQueryLogConfigResponse.ReadOnly {
    override val resolverQueryLogConfig: Option[
      zio.aws.route53resolver.model.ResolverQueryLogConfig.ReadOnly
    ] = scala
      .Option(impl.resolverQueryLogConfig())
      .map(value =>
        zio.aws.route53resolver.model.ResolverQueryLogConfig.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.DeleteResolverQueryLogConfigResponse
  ): zio.aws.route53resolver.model.DeleteResolverQueryLogConfigResponse.ReadOnly =
    new Wrapper(impl)
}
