package zio.aws.route53resolver.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.route53resolver.model.primitives.Arn
import scala.jdk.CollectionConverters._
final case class TagResourceRequest(
    resourceArn: Arn,
    tags: Iterable[zio.aws.route53resolver.model.Tag]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.TagResourceRequest
      .builder()
      .resourceArn(Arn.unwrap(resourceArn): java.lang.String)
      .tags(tags.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.route53resolver.model.TagResourceRequest.ReadOnly =
    zio.aws.route53resolver.model.TagResourceRequest.wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53resolver.model.TagResourceRequest =
      zio.aws.route53resolver.model.TagResourceRequest(
        resourceArn,
        tags.map { item =>
          item.asEditable
        }
      )
    def resourceArn: Arn
    def tags: List[zio.aws.route53resolver.model.Tag.ReadOnly]
    def getResourceArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(resourceArn)
    def getTags
        : ZIO[Any, Nothing, List[zio.aws.route53resolver.model.Tag.ReadOnly]] =
      ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.TagResourceRequest
  ) extends zio.aws.route53resolver.model.TagResourceRequest.ReadOnly {
    override val resourceArn: Arn =
      zio.aws.route53resolver.model.primitives.Arn(impl.resourceArn())
    override val tags: List[zio.aws.route53resolver.model.Tag.ReadOnly] = impl
      .tags()
      .asScala
      .map { item =>
        zio.aws.route53resolver.model.Tag.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.TagResourceRequest
  ): zio.aws.route53resolver.model.TagResourceRequest.ReadOnly = new Wrapper(
    impl
  )
}
