package zio.aws.route53resolver.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetResolverQueryLogConfigResponse(
    resolverQueryLogConfig: Option[
      zio.aws.route53resolver.model.ResolverQueryLogConfig
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.GetResolverQueryLogConfigResponse = {
    import GetResolverQueryLogConfigResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.GetResolverQueryLogConfigResponse
      .builder()
      .optionallyWith(
        resolverQueryLogConfig.map(value => value.buildAwsValue())
      )(_.resolverQueryLogConfig)
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.GetResolverQueryLogConfigResponse.ReadOnly =
    zio.aws.route53resolver.model.GetResolverQueryLogConfigResponse
      .wrap(buildAwsValue())
}
object GetResolverQueryLogConfigResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.GetResolverQueryLogConfigResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.route53resolver.model.GetResolverQueryLogConfigResponse =
      zio.aws.route53resolver.model.GetResolverQueryLogConfigResponse(
        resolverQueryLogConfig.map(value => value.asEditable)
      )
    def resolverQueryLogConfig
        : Option[zio.aws.route53resolver.model.ResolverQueryLogConfig.ReadOnly]
    def getResolverQueryLogConfig: ZIO[
      Any,
      AwsError,
      zio.aws.route53resolver.model.ResolverQueryLogConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "resolverQueryLogConfig",
      resolverQueryLogConfig
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.GetResolverQueryLogConfigResponse
  ) extends zio.aws.route53resolver.model.GetResolverQueryLogConfigResponse.ReadOnly {
    override val resolverQueryLogConfig: Option[
      zio.aws.route53resolver.model.ResolverQueryLogConfig.ReadOnly
    ] = scala
      .Option(impl.resolverQueryLogConfig())
      .map(value =>
        zio.aws.route53resolver.model.ResolverQueryLogConfig.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.GetResolverQueryLogConfigResponse
  ): zio.aws.route53resolver.model.GetResolverQueryLogConfigResponse.ReadOnly =
    new Wrapper(impl)
}
