package zio.aws.route53resolver.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.route53resolver.model.primitives.{NextToken, MaxResults}
import scala.jdk.CollectionConverters._
final case class ListResolverEndpointsRequest(
    maxResults: Option[MaxResults] = None,
    nextToken: Option[NextToken] = None,
    filters: Option[Iterable[zio.aws.route53resolver.model.Filter]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.ListResolverEndpointsRequest = {
    import ListResolverEndpointsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.ListResolverEndpointsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.ListResolverEndpointsRequest.ReadOnly =
    zio.aws.route53resolver.model.ListResolverEndpointsRequest
      .wrap(buildAwsValue())
}
object ListResolverEndpointsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.ListResolverEndpointsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53resolver.model.ListResolverEndpointsRequest =
      zio.aws.route53resolver.model.ListResolverEndpointsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def maxResults: Option[MaxResults]
    def nextToken: Option[NextToken]
    def filters: Option[List[zio.aws.route53resolver.model.Filter.ReadOnly]]
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.route53resolver.model.Filter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.ListResolverEndpointsRequest
  ) extends zio.aws.route53resolver.model.ListResolverEndpointsRequest.ReadOnly {
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.route53resolver.model.primitives.MaxResults(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.route53resolver.model.primitives.NextToken(value))
    override val filters
        : Option[List[zio.aws.route53resolver.model.Filter.ReadOnly]] = scala
      .Option(impl.filters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.route53resolver.model.Filter.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.ListResolverEndpointsRequest
  ): zio.aws.route53resolver.model.ListResolverEndpointsRequest.ReadOnly =
    new Wrapper(impl)
}
