package zio.aws.route53resolver.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.route53resolver.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListFirewallDomainListsResponse(
    nextToken: Option[NextToken] = None,
    firewallDomainLists: Option[
      Iterable[zio.aws.route53resolver.model.FirewallDomainListMetadata]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.ListFirewallDomainListsResponse = {
    import ListFirewallDomainListsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.ListFirewallDomainListsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        firewallDomainLists.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.firewallDomainLists)
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.ListFirewallDomainListsResponse.ReadOnly =
    zio.aws.route53resolver.model.ListFirewallDomainListsResponse
      .wrap(buildAwsValue())
}
object ListFirewallDomainListsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.ListFirewallDomainListsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.route53resolver.model.ListFirewallDomainListsResponse =
      zio.aws.route53resolver.model.ListFirewallDomainListsResponse(
        nextToken.map(value => value),
        firewallDomainLists.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Option[NextToken]
    def firewallDomainLists: Option[
      List[zio.aws.route53resolver.model.FirewallDomainListMetadata.ReadOnly]
    ]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getFirewallDomainLists: ZIO[Any, AwsError, List[
      zio.aws.route53resolver.model.FirewallDomainListMetadata.ReadOnly
    ]] = AwsError.unwrapOptionField("firewallDomainLists", firewallDomainLists)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.ListFirewallDomainListsResponse
  ) extends zio.aws.route53resolver.model.ListFirewallDomainListsResponse.ReadOnly {
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.route53resolver.model.primitives.NextToken(value))
    override val firewallDomainLists: Option[
      List[zio.aws.route53resolver.model.FirewallDomainListMetadata.ReadOnly]
    ] = scala
      .Option(impl.firewallDomainLists())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.route53resolver.model.FirewallDomainListMetadata.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.ListFirewallDomainListsResponse
  ): zio.aws.route53resolver.model.ListFirewallDomainListsResponse.ReadOnly =
    new Wrapper(impl)
}
