package zio.aws.route53resolver.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.route53resolver.model.primitives.{Port, Ip}
import scala.jdk.CollectionConverters._
final case class TargetAddress(ip: Ip, port: Option[Port] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.TargetAddress = {
    import TargetAddress.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.TargetAddress
      .builder()
      .ip(Ip.unwrap(ip): java.lang.String)
      .optionallyWith(port.map(value => Port.unwrap(value): Integer))(_.port)
      .build()
  }
  def asReadOnly: zio.aws.route53resolver.model.TargetAddress.ReadOnly =
    zio.aws.route53resolver.model.TargetAddress.wrap(buildAwsValue())
}
object TargetAddress {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.TargetAddress
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53resolver.model.TargetAddress =
      zio.aws.route53resolver.model.TargetAddress(ip, port.map(value => value))
    def ip: Ip
    def port: Option[Port]
    def getIp: ZIO[Any, Nothing, Ip] = ZIO.succeed(ip)
    def getPort: ZIO[Any, AwsError, Port] =
      AwsError.unwrapOptionField("port", port)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.TargetAddress
  ) extends zio.aws.route53resolver.model.TargetAddress.ReadOnly {
    override val ip: Ip = zio.aws.route53resolver.model.primitives.Ip(impl.ip())
    override val port: Option[Port] = scala
      .Option(impl.port())
      .map(value => zio.aws.route53resolver.model.primitives.Port(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.TargetAddress
  ): zio.aws.route53resolver.model.TargetAddress.ReadOnly = new Wrapper(impl)
}
