package zio.aws.route53resolver.model
import scala.jdk.CollectionConverters._
sealed trait Action {
  def unwrap: software.amazon.awssdk.services.route53resolver.model.Action
}
object Action {
  def wrap(
      value: software.amazon.awssdk.services.route53resolver.model.Action
  ): zio.aws.route53resolver.model.Action = value match {
    case software.amazon.awssdk.services.route53resolver.model.Action.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.route53resolver.model.Action.ALLOW =>
      val r = ALLOW
      r
    case software.amazon.awssdk.services.route53resolver.model.Action.BLOCK =>
      val r = BLOCK
      r
    case software.amazon.awssdk.services.route53resolver.model.Action.ALERT =>
      val r = ALERT
      r
  }
  case object unknownToSdkVersion extends zio.aws.route53resolver.model.Action {
    override def unwrap
        : software.amazon.awssdk.services.route53resolver.model.Action =
      software.amazon.awssdk.services.route53resolver.model.Action.UNKNOWN_TO_SDK_VERSION
  }
  case object ALLOW extends zio.aws.route53resolver.model.Action {
    override def unwrap
        : software.amazon.awssdk.services.route53resolver.model.Action =
      software.amazon.awssdk.services.route53resolver.model.Action.ALLOW
  }
  case object BLOCK extends zio.aws.route53resolver.model.Action {
    override def unwrap
        : software.amazon.awssdk.services.route53resolver.model.Action =
      software.amazon.awssdk.services.route53resolver.model.Action.BLOCK
  }
  case object ALERT extends zio.aws.route53resolver.model.Action {
    override def unwrap
        : software.amazon.awssdk.services.route53resolver.model.Action =
      software.amazon.awssdk.services.route53resolver.model.Action.ALERT
  }
}
