package zio.aws.route53resolver.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.route53resolver.model.primitives.{
  Rfc3339TimeString,
  ResolverQueryLogConfigAssociationErrorMessage,
  ResourceId
}
import scala.jdk.CollectionConverters._
final case class ResolverQueryLogConfigAssociation(
    id: Option[ResourceId] = None,
    resolverQueryLogConfigId: Option[ResourceId] = None,
    resourceId: Option[ResourceId] = None,
    status: Option[
      zio.aws.route53resolver.model.ResolverQueryLogConfigAssociationStatus
    ] = None,
    error: Option[
      zio.aws.route53resolver.model.ResolverQueryLogConfigAssociationError
    ] = None,
    errorMessage: Option[ResolverQueryLogConfigAssociationErrorMessage] = None,
    creationTime: Option[Rfc3339TimeString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.ResolverQueryLogConfigAssociation = {
    import ResolverQueryLogConfigAssociation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.ResolverQueryLogConfigAssociation
      .builder()
      .optionallyWith(
        id.map(value => ResourceId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        resolverQueryLogConfigId.map(value =>
          ResourceId.unwrap(value): java.lang.String
        )
      )(_.resolverQueryLogConfigId)
      .optionallyWith(
        resourceId.map(value => ResourceId.unwrap(value): java.lang.String)
      )(_.resourceId)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(error.map(value => value.unwrap))(_.error)
      .optionallyWith(
        errorMessage.map(value =>
          ResolverQueryLogConfigAssociationErrorMessage.unwrap(
            value
          ): java.lang.String
        )
      )(_.errorMessage)
      .optionallyWith(
        creationTime.map(value =>
          Rfc3339TimeString.unwrap(value): java.lang.String
        )
      )(_.creationTime)
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.ResolverQueryLogConfigAssociation.ReadOnly =
    zio.aws.route53resolver.model.ResolverQueryLogConfigAssociation
      .wrap(buildAwsValue())
}
object ResolverQueryLogConfigAssociation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.ResolverQueryLogConfigAssociation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.route53resolver.model.ResolverQueryLogConfigAssociation =
      zio.aws.route53resolver.model.ResolverQueryLogConfigAssociation(
        id.map(value => value),
        resolverQueryLogConfigId.map(value => value),
        resourceId.map(value => value),
        status.map(value => value),
        error.map(value => value),
        errorMessage.map(value => value),
        creationTime.map(value => value)
      )
    def id: Option[ResourceId]
    def resolverQueryLogConfigId: Option[ResourceId]
    def resourceId: Option[ResourceId]
    def status: Option[
      zio.aws.route53resolver.model.ResolverQueryLogConfigAssociationStatus
    ]
    def error: Option[
      zio.aws.route53resolver.model.ResolverQueryLogConfigAssociationError
    ]
    def errorMessage: Option[ResolverQueryLogConfigAssociationErrorMessage]
    def creationTime: Option[Rfc3339TimeString]
    def getId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("id", id)
    def getResolverQueryLogConfigId: ZIO[Any, AwsError, ResourceId] = AwsError
      .unwrapOptionField("resolverQueryLogConfigId", resolverQueryLogConfigId)
    def getResourceId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("resourceId", resourceId)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.route53resolver.model.ResolverQueryLogConfigAssociationStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getError: ZIO[
      Any,
      AwsError,
      zio.aws.route53resolver.model.ResolverQueryLogConfigAssociationError
    ] = AwsError.unwrapOptionField("error", error)
    def getErrorMessage
        : ZIO[Any, AwsError, ResolverQueryLogConfigAssociationErrorMessage] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
    def getCreationTime: ZIO[Any, AwsError, Rfc3339TimeString] =
      AwsError.unwrapOptionField("creationTime", creationTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.ResolverQueryLogConfigAssociation
  ) extends zio.aws.route53resolver.model.ResolverQueryLogConfigAssociation.ReadOnly {
    override val id: Option[ResourceId] = scala
      .Option(impl.id())
      .map(value => zio.aws.route53resolver.model.primitives.ResourceId(value))
    override val resolverQueryLogConfigId: Option[ResourceId] = scala
      .Option(impl.resolverQueryLogConfigId())
      .map(value => zio.aws.route53resolver.model.primitives.ResourceId(value))
    override val resourceId: Option[ResourceId] = scala
      .Option(impl.resourceId())
      .map(value => zio.aws.route53resolver.model.primitives.ResourceId(value))
    override val status: Option[
      zio.aws.route53resolver.model.ResolverQueryLogConfigAssociationStatus
    ] = scala
      .Option(impl.status())
      .map(value =>
        zio.aws.route53resolver.model.ResolverQueryLogConfigAssociationStatus
          .wrap(value)
      )
    override val error: Option[
      zio.aws.route53resolver.model.ResolverQueryLogConfigAssociationError
    ] = scala
      .Option(impl.error())
      .map(value =>
        zio.aws.route53resolver.model.ResolverQueryLogConfigAssociationError
          .wrap(value)
      )
    override val errorMessage
        : Option[ResolverQueryLogConfigAssociationErrorMessage] = scala
      .Option(impl.errorMessage())
      .map(value =>
        zio.aws.route53resolver.model.primitives
          .ResolverQueryLogConfigAssociationErrorMessage(value)
      )
    override val creationTime: Option[Rfc3339TimeString] = scala
      .Option(impl.creationTime())
      .map(value =>
        zio.aws.route53resolver.model.primitives.Rfc3339TimeString(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.ResolverQueryLogConfigAssociation
  ): zio.aws.route53resolver.model.ResolverQueryLogConfigAssociation.ReadOnly =
    new Wrapper(impl)
}
