package zio.aws.route53resolver.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetFirewallConfigResponse(
    firewallConfig: Option[zio.aws.route53resolver.model.FirewallConfig] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.GetFirewallConfigResponse = {
    import GetFirewallConfigResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.GetFirewallConfigResponse
      .builder()
      .optionallyWith(firewallConfig.map(value => value.buildAwsValue()))(
        _.firewallConfig
      )
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.GetFirewallConfigResponse.ReadOnly =
    zio.aws.route53resolver.model.GetFirewallConfigResponse
      .wrap(buildAwsValue())
}
object GetFirewallConfigResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.GetFirewallConfigResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53resolver.model.GetFirewallConfigResponse =
      zio.aws.route53resolver.model.GetFirewallConfigResponse(
        firewallConfig.map(value => value.asEditable)
      )
    def firewallConfig
        : Option[zio.aws.route53resolver.model.FirewallConfig.ReadOnly]
    def getFirewallConfig: ZIO[
      Any,
      AwsError,
      zio.aws.route53resolver.model.FirewallConfig.ReadOnly
    ] = AwsError.unwrapOptionField("firewallConfig", firewallConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.GetFirewallConfigResponse
  ) extends zio.aws.route53resolver.model.GetFirewallConfigResponse.ReadOnly {
    override val firewallConfig
        : Option[zio.aws.route53resolver.model.FirewallConfig.ReadOnly] = scala
      .Option(impl.firewallConfig())
      .map(value => zio.aws.route53resolver.model.FirewallConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.GetFirewallConfigResponse
  ): zio.aws.route53resolver.model.GetFirewallConfigResponse.ReadOnly =
    new Wrapper(impl)
}
