package zio.aws.route53resolver.model
import scala.jdk.CollectionConverters._
sealed trait FirewallRuleGroupAssociationStatus {
  def unwrap: software.amazon.awssdk.services.route53resolver.model.FirewallRuleGroupAssociationStatus
}
object FirewallRuleGroupAssociationStatus {
  def wrap(
      value: software.amazon.awssdk.services.route53resolver.model.FirewallRuleGroupAssociationStatus
  ): zio.aws.route53resolver.model.FirewallRuleGroupAssociationStatus =
    value match {
      case software.amazon.awssdk.services.route53resolver.model.FirewallRuleGroupAssociationStatus.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.route53resolver.model.FirewallRuleGroupAssociationStatus.COMPLETE =>
        val r = COMPLETE
        r
      case software.amazon.awssdk.services.route53resolver.model.FirewallRuleGroupAssociationStatus.DELETING =>
        val r = DELETING
        r
      case software.amazon.awssdk.services.route53resolver.model.FirewallRuleGroupAssociationStatus.UPDATING =>
        val r = UPDATING
        r
    }
  case object unknownToSdkVersion
      extends zio.aws.route53resolver.model.FirewallRuleGroupAssociationStatus {
    override def unwrap
        : software.amazon.awssdk.services.route53resolver.model.FirewallRuleGroupAssociationStatus =
      software.amazon.awssdk.services.route53resolver.model.FirewallRuleGroupAssociationStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object COMPLETE
      extends zio.aws.route53resolver.model.FirewallRuleGroupAssociationStatus {
    override def unwrap
        : software.amazon.awssdk.services.route53resolver.model.FirewallRuleGroupAssociationStatus =
      software.amazon.awssdk.services.route53resolver.model.FirewallRuleGroupAssociationStatus.COMPLETE
  }
  case object DELETING
      extends zio.aws.route53resolver.model.FirewallRuleGroupAssociationStatus {
    override def unwrap
        : software.amazon.awssdk.services.route53resolver.model.FirewallRuleGroupAssociationStatus =
      software.amazon.awssdk.services.route53resolver.model.FirewallRuleGroupAssociationStatus.DELETING
  }
  case object UPDATING
      extends zio.aws.route53resolver.model.FirewallRuleGroupAssociationStatus {
    override def unwrap
        : software.amazon.awssdk.services.route53resolver.model.FirewallRuleGroupAssociationStatus =
      software.amazon.awssdk.services.route53resolver.model.FirewallRuleGroupAssociationStatus.UPDATING
  }
}
