package zio.aws.route53resolver.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateResolverRuleResponse(
    resolverRule: Option[zio.aws.route53resolver.model.ResolverRule] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.UpdateResolverRuleResponse = {
    import UpdateResolverRuleResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.UpdateResolverRuleResponse
      .builder()
      .optionallyWith(resolverRule.map(value => value.buildAwsValue()))(
        _.resolverRule
      )
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.UpdateResolverRuleResponse.ReadOnly =
    zio.aws.route53resolver.model.UpdateResolverRuleResponse
      .wrap(buildAwsValue())
}
object UpdateResolverRuleResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.UpdateResolverRuleResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53resolver.model.UpdateResolverRuleResponse =
      zio.aws.route53resolver.model
        .UpdateResolverRuleResponse(resolverRule.map(value => value.asEditable))
    def resolverRule
        : Option[zio.aws.route53resolver.model.ResolverRule.ReadOnly]
    def getResolverRule: ZIO[
      Any,
      AwsError,
      zio.aws.route53resolver.model.ResolverRule.ReadOnly
    ] = AwsError.unwrapOptionField("resolverRule", resolverRule)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.UpdateResolverRuleResponse
  ) extends zio.aws.route53resolver.model.UpdateResolverRuleResponse.ReadOnly {
    override val resolverRule
        : Option[zio.aws.route53resolver.model.ResolverRule.ReadOnly] = scala
      .Option(impl.resolverRule())
      .map(value => zio.aws.route53resolver.model.ResolverRule.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.UpdateResolverRuleResponse
  ): zio.aws.route53resolver.model.UpdateResolverRuleResponse.ReadOnly =
    new Wrapper(impl)
}
