package zio.aws.route53resolver.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.route53resolver.model.primitives.ResourceId
import scala.jdk.CollectionConverters._
final case class DeleteResolverQueryLogConfigRequest(
    resolverQueryLogConfigId: ResourceId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.DeleteResolverQueryLogConfigRequest = {
    import DeleteResolverQueryLogConfigRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.DeleteResolverQueryLogConfigRequest
      .builder()
      .resolverQueryLogConfigId(
        ResourceId.unwrap(resolverQueryLogConfigId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.DeleteResolverQueryLogConfigRequest.ReadOnly =
    zio.aws.route53resolver.model.DeleteResolverQueryLogConfigRequest
      .wrap(buildAwsValue())
}
object DeleteResolverQueryLogConfigRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.DeleteResolverQueryLogConfigRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.route53resolver.model.DeleteResolverQueryLogConfigRequest =
      zio.aws.route53resolver.model
        .DeleteResolverQueryLogConfigRequest(resolverQueryLogConfigId)
    def resolverQueryLogConfigId: ResourceId
    def getResolverQueryLogConfigId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(resolverQueryLogConfigId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.DeleteResolverQueryLogConfigRequest
  ) extends zio.aws.route53resolver.model.DeleteResolverQueryLogConfigRequest.ReadOnly {
    override val resolverQueryLogConfigId: ResourceId =
      zio.aws.route53resolver.model.primitives
        .ResourceId(impl.resolverQueryLogConfigId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.DeleteResolverQueryLogConfigRequest
  ): zio.aws.route53resolver.model.DeleteResolverQueryLogConfigRequest.ReadOnly =
    new Wrapper(impl)
}
