package zio.aws.route53resolver.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PutFirewallRuleGroupPolicyResponse(
    returnValue: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.PutFirewallRuleGroupPolicyResponse = {
    import PutFirewallRuleGroupPolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.PutFirewallRuleGroupPolicyResponse
      .builder()
      .optionallyWith(returnValue.map(value => value: java.lang.Boolean))(
        _.returnValue
      )
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.PutFirewallRuleGroupPolicyResponse.ReadOnly =
    zio.aws.route53resolver.model.PutFirewallRuleGroupPolicyResponse
      .wrap(buildAwsValue())
}
object PutFirewallRuleGroupPolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.PutFirewallRuleGroupPolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.route53resolver.model.PutFirewallRuleGroupPolicyResponse =
      zio.aws.route53resolver.model
        .PutFirewallRuleGroupPolicyResponse(returnValue.map(value => value))
    def returnValue: Option[Boolean]
    def getReturnValue: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("returnValue", returnValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.PutFirewallRuleGroupPolicyResponse
  ) extends zio.aws.route53resolver.model.PutFirewallRuleGroupPolicyResponse.ReadOnly {
    override val returnValue: Option[Boolean] =
      scala.Option(impl.returnValue()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.PutFirewallRuleGroupPolicyResponse
  ): zio.aws.route53resolver.model.PutFirewallRuleGroupPolicyResponse.ReadOnly =
    new Wrapper(impl)
}
