package zio.aws.route53resolver.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.route53resolver.model.primitives.{
  NextToken,
  ListResolverConfigsMaxResult
}
import scala.jdk.CollectionConverters._
final case class ListResolverConfigsRequest(
    maxResults: Option[ListResolverConfigsMaxResult] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.ListResolverConfigsRequest = {
    import ListResolverConfigsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.ListResolverConfigsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value =>
          ListResolverConfigsMaxResult.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.ListResolverConfigsRequest.ReadOnly =
    zio.aws.route53resolver.model.ListResolverConfigsRequest
      .wrap(buildAwsValue())
}
object ListResolverConfigsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.ListResolverConfigsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53resolver.model.ListResolverConfigsRequest =
      zio.aws.route53resolver.model.ListResolverConfigsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def maxResults: Option[ListResolverConfigsMaxResult]
    def nextToken: Option[NextToken]
    def getMaxResults: ZIO[Any, AwsError, ListResolverConfigsMaxResult] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.ListResolverConfigsRequest
  ) extends zio.aws.route53resolver.model.ListResolverConfigsRequest.ReadOnly {
    override val maxResults: Option[ListResolverConfigsMaxResult] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.route53resolver.model.primitives
          .ListResolverConfigsMaxResult(value)
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.route53resolver.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.ListResolverConfigsRequest
  ): zio.aws.route53resolver.model.ListResolverConfigsRequest.ReadOnly =
    new Wrapper(impl)
}
