package zio.aws.route53resolver.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.route53resolver.model.primitives.ResourceId
import scala.jdk.CollectionConverters._
final case class DeleteResolverEndpointRequest(resolverEndpointId: ResourceId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.DeleteResolverEndpointRequest = {
    import DeleteResolverEndpointRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.DeleteResolverEndpointRequest
      .builder()
      .resolverEndpointId(
        ResourceId.unwrap(resolverEndpointId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.DeleteResolverEndpointRequest.ReadOnly =
    zio.aws.route53resolver.model.DeleteResolverEndpointRequest
      .wrap(buildAwsValue())
}
object DeleteResolverEndpointRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.DeleteResolverEndpointRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.route53resolver.model.DeleteResolverEndpointRequest =
      zio.aws.route53resolver.model
        .DeleteResolverEndpointRequest(resolverEndpointId)
    def resolverEndpointId: ResourceId
    def getResolverEndpointId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(resolverEndpointId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.DeleteResolverEndpointRequest
  ) extends zio.aws.route53resolver.model.DeleteResolverEndpointRequest.ReadOnly {
    override val resolverEndpointId: ResourceId =
      zio.aws.route53resolver.model.primitives
        .ResourceId(impl.resolverEndpointId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.DeleteResolverEndpointRequest
  ): zio.aws.route53resolver.model.DeleteResolverEndpointRequest.ReadOnly =
    new Wrapper(impl)
}
