package zio.aws.route53resolver.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.route53resolver.model.primitives.{Ip, SubnetId}
import scala.jdk.CollectionConverters._
final case class IpAddressRequest(subnetId: SubnetId, ip: Option[Ip] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.IpAddressRequest = {
    import IpAddressRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.IpAddressRequest
      .builder()
      .subnetId(SubnetId.unwrap(subnetId): java.lang.String)
      .optionallyWith(ip.map(value => Ip.unwrap(value): java.lang.String))(_.ip)
      .build()
  }
  def asReadOnly: zio.aws.route53resolver.model.IpAddressRequest.ReadOnly =
    zio.aws.route53resolver.model.IpAddressRequest.wrap(buildAwsValue())
}
object IpAddressRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.IpAddressRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53resolver.model.IpAddressRequest =
      zio.aws.route53resolver.model
        .IpAddressRequest(subnetId, ip.map(value => value))
    def subnetId: SubnetId
    def ip: Option[Ip]
    def getSubnetId: ZIO[Any, Nothing, SubnetId] = ZIO.succeed(subnetId)
    def getIp: ZIO[Any, AwsError, Ip] = AwsError.unwrapOptionField("ip", ip)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.IpAddressRequest
  ) extends zio.aws.route53resolver.model.IpAddressRequest.ReadOnly {
    override val subnetId: SubnetId =
      zio.aws.route53resolver.model.primitives.SubnetId(impl.subnetId())
    override val ip: Option[Ip] = scala
      .Option(impl.ip())
      .map(value => zio.aws.route53resolver.model.primitives.Ip(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.IpAddressRequest
  ): zio.aws.route53resolver.model.IpAddressRequest.ReadOnly = new Wrapper(impl)
}
