package zio.aws.route53resolver.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.route53resolver.model.primitives.{
  ResourceId,
  DomainName,
  Name,
  CreatorRequestId
}
import scala.jdk.CollectionConverters._
final case class CreateResolverRuleRequest(
    creatorRequestId: CreatorRequestId,
    name: Option[Name] = None,
    ruleType: zio.aws.route53resolver.model.RuleTypeOption,
    domainName: DomainName,
    targetIps: Option[Iterable[zio.aws.route53resolver.model.TargetAddress]] =
      None,
    resolverEndpointId: Option[ResourceId] = None,
    tags: Option[Iterable[zio.aws.route53resolver.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.CreateResolverRuleRequest = {
    import CreateResolverRuleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.CreateResolverRuleRequest
      .builder()
      .creatorRequestId(
        CreatorRequestId.unwrap(creatorRequestId): java.lang.String
      )
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .ruleType(ruleType.unwrap)
      .domainName(DomainName.unwrap(domainName): java.lang.String)
      .optionallyWith(
        targetIps.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.targetIps)
      .optionallyWith(
        resolverEndpointId.map(value =>
          ResourceId.unwrap(value): java.lang.String
        )
      )(_.resolverEndpointId)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.CreateResolverRuleRequest.ReadOnly =
    zio.aws.route53resolver.model.CreateResolverRuleRequest
      .wrap(buildAwsValue())
}
object CreateResolverRuleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.CreateResolverRuleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53resolver.model.CreateResolverRuleRequest =
      zio.aws.route53resolver.model.CreateResolverRuleRequest(
        creatorRequestId,
        name.map(value => value),
        ruleType,
        domainName,
        targetIps.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resolverEndpointId.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def creatorRequestId: CreatorRequestId
    def name: Option[Name]
    def ruleType: zio.aws.route53resolver.model.RuleTypeOption
    def domainName: DomainName
    def targetIps
        : Option[List[zio.aws.route53resolver.model.TargetAddress.ReadOnly]]
    def resolverEndpointId: Option[ResourceId]
    def tags: Option[List[zio.aws.route53resolver.model.Tag.ReadOnly]]
    def getCreatorRequestId: ZIO[Any, Nothing, CreatorRequestId] =
      ZIO.succeed(creatorRequestId)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getRuleType
        : ZIO[Any, Nothing, zio.aws.route53resolver.model.RuleTypeOption] =
      ZIO.succeed(ruleType)
    def getDomainName: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domainName)
    def getTargetIps: ZIO[Any, AwsError, List[
      zio.aws.route53resolver.model.TargetAddress.ReadOnly
    ]] = AwsError.unwrapOptionField("targetIps", targetIps)
    def getResolverEndpointId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("resolverEndpointId", resolverEndpointId)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.route53resolver.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.CreateResolverRuleRequest
  ) extends zio.aws.route53resolver.model.CreateResolverRuleRequest.ReadOnly {
    override val creatorRequestId: CreatorRequestId =
      zio.aws.route53resolver.model.primitives
        .CreatorRequestId(impl.creatorRequestId())
    override val name: Option[Name] = scala
      .Option(impl.name())
      .map(value => zio.aws.route53resolver.model.primitives.Name(value))
    override val ruleType: zio.aws.route53resolver.model.RuleTypeOption =
      zio.aws.route53resolver.model.RuleTypeOption.wrap(impl.ruleType())
    override val domainName: DomainName =
      zio.aws.route53resolver.model.primitives.DomainName(impl.domainName())
    override val targetIps
        : Option[List[zio.aws.route53resolver.model.TargetAddress.ReadOnly]] =
      scala
        .Option(impl.targetIps())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.route53resolver.model.TargetAddress.wrap(item)
          }.toList
        )
    override val resolverEndpointId: Option[ResourceId] = scala
      .Option(impl.resolverEndpointId())
      .map(value => zio.aws.route53resolver.model.primitives.ResourceId(value))
    override val tags
        : Option[List[zio.aws.route53resolver.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.route53resolver.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.CreateResolverRuleRequest
  ): zio.aws.route53resolver.model.CreateResolverRuleRequest.ReadOnly =
    new Wrapper(impl)
}
