package zio.aws.route53resolver.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.route53resolver.model.primitives.{
  CreatorRequestId,
  AccountId,
  Arn,
  Name,
  ResourceId
}
import scala.jdk.CollectionConverters._
final case class FirewallRuleGroupMetadata(
    id: Option[ResourceId] = None,
    arn: Option[Arn] = None,
    name: Option[Name] = None,
    ownerId: Option[AccountId] = None,
    creatorRequestId: Option[CreatorRequestId] = None,
    shareStatus: Option[zio.aws.route53resolver.model.ShareStatus] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.FirewallRuleGroupMetadata = {
    import FirewallRuleGroupMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.FirewallRuleGroupMetadata
      .builder()
      .optionallyWith(
        id.map(value => ResourceId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        ownerId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.ownerId)
      .optionallyWith(
        creatorRequestId.map(value =>
          CreatorRequestId.unwrap(value): java.lang.String
        )
      )(_.creatorRequestId)
      .optionallyWith(shareStatus.map(value => value.unwrap))(_.shareStatus)
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.FirewallRuleGroupMetadata.ReadOnly =
    zio.aws.route53resolver.model.FirewallRuleGroupMetadata
      .wrap(buildAwsValue())
}
object FirewallRuleGroupMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.FirewallRuleGroupMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53resolver.model.FirewallRuleGroupMetadata =
      zio.aws.route53resolver.model.FirewallRuleGroupMetadata(
        id.map(value => value),
        arn.map(value => value),
        name.map(value => value),
        ownerId.map(value => value),
        creatorRequestId.map(value => value),
        shareStatus.map(value => value)
      )
    def id: Option[ResourceId]
    def arn: Option[Arn]
    def name: Option[Name]
    def ownerId: Option[AccountId]
    def creatorRequestId: Option[CreatorRequestId]
    def shareStatus: Option[zio.aws.route53resolver.model.ShareStatus]
    def getId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("id", id)
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getOwnerId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("ownerId", ownerId)
    def getCreatorRequestId: ZIO[Any, AwsError, CreatorRequestId] =
      AwsError.unwrapOptionField("creatorRequestId", creatorRequestId)
    def getShareStatus
        : ZIO[Any, AwsError, zio.aws.route53resolver.model.ShareStatus] =
      AwsError.unwrapOptionField("shareStatus", shareStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.FirewallRuleGroupMetadata
  ) extends zio.aws.route53resolver.model.FirewallRuleGroupMetadata.ReadOnly {
    override val id: Option[ResourceId] = scala
      .Option(impl.id())
      .map(value => zio.aws.route53resolver.model.primitives.ResourceId(value))
    override val arn: Option[Arn] = scala
      .Option(impl.arn())
      .map(value => zio.aws.route53resolver.model.primitives.Arn(value))
    override val name: Option[Name] = scala
      .Option(impl.name())
      .map(value => zio.aws.route53resolver.model.primitives.Name(value))
    override val ownerId: Option[AccountId] = scala
      .Option(impl.ownerId())
      .map(value => zio.aws.route53resolver.model.primitives.AccountId(value))
    override val creatorRequestId: Option[CreatorRequestId] = scala
      .Option(impl.creatorRequestId())
      .map(value =>
        zio.aws.route53resolver.model.primitives.CreatorRequestId(value)
      )
    override val shareStatus
        : Option[zio.aws.route53resolver.model.ShareStatus] = scala
      .Option(impl.shareStatus())
      .map(value => zio.aws.route53resolver.model.ShareStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.FirewallRuleGroupMetadata
  ): zio.aws.route53resolver.model.FirewallRuleGroupMetadata.ReadOnly =
    new Wrapper(impl)
}
