package zio.aws.route53resolver.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.route53resolver.model.primitives.{ResolverRulePolicy, Arn}
import scala.jdk.CollectionConverters._
final case class PutResolverRulePolicyRequest(
    arn: Arn,
    resolverRulePolicy: ResolverRulePolicy
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.PutResolverRulePolicyRequest = {
    import PutResolverRulePolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.PutResolverRulePolicyRequest
      .builder()
      .arn(Arn.unwrap(arn): java.lang.String)
      .resolverRulePolicy(
        ResolverRulePolicy.unwrap(resolverRulePolicy): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.PutResolverRulePolicyRequest.ReadOnly =
    zio.aws.route53resolver.model.PutResolverRulePolicyRequest
      .wrap(buildAwsValue())
}
object PutResolverRulePolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.PutResolverRulePolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53resolver.model.PutResolverRulePolicyRequest =
      zio.aws.route53resolver.model
        .PutResolverRulePolicyRequest(arn, resolverRulePolicy)
    def arn: Arn
    def resolverRulePolicy: ResolverRulePolicy
    def getArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(arn)
    def getResolverRulePolicy: ZIO[Any, Nothing, ResolverRulePolicy] =
      ZIO.succeed(resolverRulePolicy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.PutResolverRulePolicyRequest
  ) extends zio.aws.route53resolver.model.PutResolverRulePolicyRequest.ReadOnly {
    override val arn: Arn =
      zio.aws.route53resolver.model.primitives.Arn(impl.arn())
    override val resolverRulePolicy: ResolverRulePolicy =
      zio.aws.route53resolver.model.primitives
        .ResolverRulePolicy(impl.resolverRulePolicy())
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.PutResolverRulePolicyRequest
  ): zio.aws.route53resolver.model.PutResolverRulePolicyRequest.ReadOnly =
    new Wrapper(impl)
}
