package zio.aws.route53resolver.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.route53resolver.model.primitives.{
  SubnetId,
  Ip,
  Rfc3339TimeString,
  ResourceId,
  StatusMessage
}
import scala.jdk.CollectionConverters._
final case class IpAddressResponse(
    ipId: Option[ResourceId] = None,
    subnetId: Option[SubnetId] = None,
    ip: Option[Ip] = None,
    status: Option[zio.aws.route53resolver.model.IpAddressStatus] = None,
    statusMessage: Option[StatusMessage] = None,
    creationTime: Option[Rfc3339TimeString] = None,
    modificationTime: Option[Rfc3339TimeString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.IpAddressResponse = {
    import IpAddressResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.IpAddressResponse
      .builder()
      .optionallyWith(
        ipId.map(value => ResourceId.unwrap(value): java.lang.String)
      )(_.ipId)
      .optionallyWith(
        subnetId.map(value => SubnetId.unwrap(value): java.lang.String)
      )(_.subnetId)
      .optionallyWith(ip.map(value => Ip.unwrap(value): java.lang.String))(_.ip)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        statusMessage.map(value =>
          StatusMessage.unwrap(value): java.lang.String
        )
      )(_.statusMessage)
      .optionallyWith(
        creationTime.map(value =>
          Rfc3339TimeString.unwrap(value): java.lang.String
        )
      )(_.creationTime)
      .optionallyWith(
        modificationTime.map(value =>
          Rfc3339TimeString.unwrap(value): java.lang.String
        )
      )(_.modificationTime)
      .build()
  }
  def asReadOnly: zio.aws.route53resolver.model.IpAddressResponse.ReadOnly =
    zio.aws.route53resolver.model.IpAddressResponse.wrap(buildAwsValue())
}
object IpAddressResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.IpAddressResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53resolver.model.IpAddressResponse =
      zio.aws.route53resolver.model.IpAddressResponse(
        ipId.map(value => value),
        subnetId.map(value => value),
        ip.map(value => value),
        status.map(value => value),
        statusMessage.map(value => value),
        creationTime.map(value => value),
        modificationTime.map(value => value)
      )
    def ipId: Option[ResourceId]
    def subnetId: Option[SubnetId]
    def ip: Option[Ip]
    def status: Option[zio.aws.route53resolver.model.IpAddressStatus]
    def statusMessage: Option[StatusMessage]
    def creationTime: Option[Rfc3339TimeString]
    def modificationTime: Option[Rfc3339TimeString]
    def getIpId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("ipId", ipId)
    def getSubnetId: ZIO[Any, AwsError, SubnetId] =
      AwsError.unwrapOptionField("subnetId", subnetId)
    def getIp: ZIO[Any, AwsError, Ip] = AwsError.unwrapOptionField("ip", ip)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.route53resolver.model.IpAddressStatus] =
      AwsError.unwrapOptionField("status", status)
    def getStatusMessage: ZIO[Any, AwsError, StatusMessage] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getCreationTime: ZIO[Any, AwsError, Rfc3339TimeString] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getModificationTime: ZIO[Any, AwsError, Rfc3339TimeString] =
      AwsError.unwrapOptionField("modificationTime", modificationTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.IpAddressResponse
  ) extends zio.aws.route53resolver.model.IpAddressResponse.ReadOnly {
    override val ipId: Option[ResourceId] = scala
      .Option(impl.ipId())
      .map(value => zio.aws.route53resolver.model.primitives.ResourceId(value))
    override val subnetId: Option[SubnetId] = scala
      .Option(impl.subnetId())
      .map(value => zio.aws.route53resolver.model.primitives.SubnetId(value))
    override val ip: Option[Ip] = scala
      .Option(impl.ip())
      .map(value => zio.aws.route53resolver.model.primitives.Ip(value))
    override val status: Option[zio.aws.route53resolver.model.IpAddressStatus] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.route53resolver.model.IpAddressStatus.wrap(value))
    override val statusMessage: Option[StatusMessage] = scala
      .Option(impl.statusMessage())
      .map(value =>
        zio.aws.route53resolver.model.primitives.StatusMessage(value)
      )
    override val creationTime: Option[Rfc3339TimeString] = scala
      .Option(impl.creationTime())
      .map(value =>
        zio.aws.route53resolver.model.primitives.Rfc3339TimeString(value)
      )
    override val modificationTime: Option[Rfc3339TimeString] = scala
      .Option(impl.modificationTime())
      .map(value =>
        zio.aws.route53resolver.model.primitives.Rfc3339TimeString(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.IpAddressResponse
  ): zio.aws.route53resolver.model.IpAddressResponse.ReadOnly = new Wrapper(
    impl
  )
}
