package zio.aws.route53resolver.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.route53resolver.model.primitives.{
  Name,
  Priority,
  ResourceId,
  CreatorRequestId
}
import scala.jdk.CollectionConverters._
final case class AssociateFirewallRuleGroupRequest(
    creatorRequestId: CreatorRequestId,
    firewallRuleGroupId: ResourceId,
    vpcId: ResourceId,
    priority: Priority,
    name: Name,
    mutationProtection: Option[
      zio.aws.route53resolver.model.MutationProtectionStatus
    ] = None,
    tags: Option[Iterable[zio.aws.route53resolver.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.AssociateFirewallRuleGroupRequest = {
    import AssociateFirewallRuleGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.AssociateFirewallRuleGroupRequest
      .builder()
      .creatorRequestId(
        CreatorRequestId.unwrap(creatorRequestId): java.lang.String
      )
      .firewallRuleGroupId(
        ResourceId.unwrap(firewallRuleGroupId): java.lang.String
      )
      .vpcId(ResourceId.unwrap(vpcId): java.lang.String)
      .priority(Priority.unwrap(priority): Integer)
      .name(Name.unwrap(name): java.lang.String)
      .optionallyWith(mutationProtection.map(value => value.unwrap))(
        _.mutationProtection
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.AssociateFirewallRuleGroupRequest.ReadOnly =
    zio.aws.route53resolver.model.AssociateFirewallRuleGroupRequest
      .wrap(buildAwsValue())
}
object AssociateFirewallRuleGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.AssociateFirewallRuleGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.route53resolver.model.AssociateFirewallRuleGroupRequest =
      zio.aws.route53resolver.model.AssociateFirewallRuleGroupRequest(
        creatorRequestId,
        firewallRuleGroupId,
        vpcId,
        priority,
        name,
        mutationProtection.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def creatorRequestId: CreatorRequestId
    def firewallRuleGroupId: ResourceId
    def vpcId: ResourceId
    def priority: Priority
    def name: Name
    def mutationProtection
        : Option[zio.aws.route53resolver.model.MutationProtectionStatus]
    def tags: Option[List[zio.aws.route53resolver.model.Tag.ReadOnly]]
    def getCreatorRequestId: ZIO[Any, Nothing, CreatorRequestId] =
      ZIO.succeed(creatorRequestId)
    def getFirewallRuleGroupId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(firewallRuleGroupId)
    def getVpcId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(vpcId)
    def getPriority: ZIO[Any, Nothing, Priority] = ZIO.succeed(priority)
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getMutationProtection: ZIO[
      Any,
      AwsError,
      zio.aws.route53resolver.model.MutationProtectionStatus
    ] = AwsError.unwrapOptionField("mutationProtection", mutationProtection)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.route53resolver.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.AssociateFirewallRuleGroupRequest
  ) extends zio.aws.route53resolver.model.AssociateFirewallRuleGroupRequest.ReadOnly {
    override val creatorRequestId: CreatorRequestId =
      zio.aws.route53resolver.model.primitives
        .CreatorRequestId(impl.creatorRequestId())
    override val firewallRuleGroupId: ResourceId =
      zio.aws.route53resolver.model.primitives
        .ResourceId(impl.firewallRuleGroupId())
    override val vpcId: ResourceId =
      zio.aws.route53resolver.model.primitives.ResourceId(impl.vpcId())
    override val priority: Priority =
      zio.aws.route53resolver.model.primitives.Priority(impl.priority())
    override val name: Name =
      zio.aws.route53resolver.model.primitives.Name(impl.name())
    override val mutationProtection
        : Option[zio.aws.route53resolver.model.MutationProtectionStatus] = scala
      .Option(impl.mutationProtection())
      .map(value =>
        zio.aws.route53resolver.model.MutationProtectionStatus.wrap(value)
      )
    override val tags
        : Option[List[zio.aws.route53resolver.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.route53resolver.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.AssociateFirewallRuleGroupRequest
  ): zio.aws.route53resolver.model.AssociateFirewallRuleGroupRequest.ReadOnly =
    new Wrapper(impl)
}
