package zio.aws.route53resolver.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.route53resolver.model.primitives.{NextToken, MaxResults}
import scala.jdk.CollectionConverters._
final case class ListFirewallDomainListsRequest(
    maxResults: Option[MaxResults] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.ListFirewallDomainListsRequest = {
    import ListFirewallDomainListsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.ListFirewallDomainListsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.ListFirewallDomainListsRequest.ReadOnly =
    zio.aws.route53resolver.model.ListFirewallDomainListsRequest
      .wrap(buildAwsValue())
}
object ListFirewallDomainListsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.ListFirewallDomainListsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.route53resolver.model.ListFirewallDomainListsRequest =
      zio.aws.route53resolver.model.ListFirewallDomainListsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def maxResults: Option[MaxResults]
    def nextToken: Option[NextToken]
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.ListFirewallDomainListsRequest
  ) extends zio.aws.route53resolver.model.ListFirewallDomainListsRequest.ReadOnly {
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.route53resolver.model.primitives.MaxResults(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.route53resolver.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.ListFirewallDomainListsRequest
  ): zio.aws.route53resolver.model.ListFirewallDomainListsRequest.ReadOnly =
    new Wrapper(impl)
}
