package zio.aws.route53resolver.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetResolverConfigResponse(
    resolverConfig: Option[zio.aws.route53resolver.model.ResolverConfig] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.GetResolverConfigResponse = {
    import GetResolverConfigResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.GetResolverConfigResponse
      .builder()
      .optionallyWith(resolverConfig.map(value => value.buildAwsValue()))(
        _.resolverConfig
      )
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.GetResolverConfigResponse.ReadOnly =
    zio.aws.route53resolver.model.GetResolverConfigResponse
      .wrap(buildAwsValue())
}
object GetResolverConfigResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.GetResolverConfigResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53resolver.model.GetResolverConfigResponse =
      zio.aws.route53resolver.model.GetResolverConfigResponse(
        resolverConfig.map(value => value.asEditable)
      )
    def resolverConfig
        : Option[zio.aws.route53resolver.model.ResolverConfig.ReadOnly]
    def getResolverConfig: ZIO[
      Any,
      AwsError,
      zio.aws.route53resolver.model.ResolverConfig.ReadOnly
    ] = AwsError.unwrapOptionField("resolverConfig", resolverConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.GetResolverConfigResponse
  ) extends zio.aws.route53resolver.model.GetResolverConfigResponse.ReadOnly {
    override val resolverConfig
        : Option[zio.aws.route53resolver.model.ResolverConfig.ReadOnly] = scala
      .Option(impl.resolverConfig())
      .map(value => zio.aws.route53resolver.model.ResolverConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.GetResolverConfigResponse
  ): zio.aws.route53resolver.model.GetResolverConfigResponse.ReadOnly =
    new Wrapper(impl)
}
