package zio.aws.route53resolver.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateOutpostResolverResponse(
    outpostResolver: Optional[zio.aws.route53resolver.model.OutpostResolver] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.CreateOutpostResolverResponse = {
    import CreateOutpostResolverResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.CreateOutpostResolverResponse
      .builder()
      .optionallyWith(outpostResolver.map(value => value.buildAwsValue()))(
        _.outpostResolver
      )
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.CreateOutpostResolverResponse.ReadOnly =
    zio.aws.route53resolver.model.CreateOutpostResolverResponse
      .wrap(buildAwsValue())
}
object CreateOutpostResolverResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.CreateOutpostResolverResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.route53resolver.model.CreateOutpostResolverResponse =
      zio.aws.route53resolver.model.CreateOutpostResolverResponse(
        outpostResolver.map(value => value.asEditable)
      )
    def outpostResolver
        : Optional[zio.aws.route53resolver.model.OutpostResolver.ReadOnly]
    def getOutpostResolver: ZIO[
      Any,
      AwsError,
      zio.aws.route53resolver.model.OutpostResolver.ReadOnly
    ] = AwsError.unwrapOptionField("outpostResolver", outpostResolver)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.CreateOutpostResolverResponse
  ) extends zio.aws.route53resolver.model.CreateOutpostResolverResponse.ReadOnly {
    override val outpostResolver
        : Optional[zio.aws.route53resolver.model.OutpostResolver.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.outpostResolver())
        .map(value => zio.aws.route53resolver.model.OutpostResolver.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.CreateOutpostResolverResponse
  ): zio.aws.route53resolver.model.CreateOutpostResolverResponse.ReadOnly =
    new Wrapper(impl)
}
