package zio.aws.route53recoverycontrolconfig.model
import zio.aws.route53recoverycontrolconfig.model.primitives.__policy
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetResourcePolicyResponse(
    policy: Optional[__policy] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53recoverycontrolconfig.model.GetResourcePolicyResponse = {
    import GetResourcePolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53recoverycontrolconfig.model.GetResourcePolicyResponse
      .builder()
      .optionallyWith(policy.map(value => value: java.lang.String))(_.policy)
      .build()
  }
  def asReadOnly
      : zio.aws.route53recoverycontrolconfig.model.GetResourcePolicyResponse.ReadOnly =
    zio.aws.route53recoverycontrolconfig.model.GetResourcePolicyResponse
      .wrap(buildAwsValue())
}
object GetResourcePolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53recoverycontrolconfig.model.GetResourcePolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.route53recoverycontrolconfig.model.GetResourcePolicyResponse =
      zio.aws.route53recoverycontrolconfig.model
        .GetResourcePolicyResponse(policy.map(value => value))
    def policy: Optional[__policy]
    def getPolicy: ZIO[Any, AwsError, __policy] =
      AwsError.unwrapOptionField("policy", policy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53recoverycontrolconfig.model.GetResourcePolicyResponse
  ) extends zio.aws.route53recoverycontrolconfig.model.GetResourcePolicyResponse.ReadOnly {
    override val policy: Optional[__policy] = zio.aws.core.internal
      .optionalFromNullable(impl.policy())
      .map(value => value: __policy)
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53recoverycontrolconfig.model.GetResourcePolicyResponse
  ): zio.aws.route53recoverycontrolconfig.model.GetResourcePolicyResponse.ReadOnly =
    new Wrapper(impl)
}
