package zio.aws.route53recoverycontrolconfig.model
import zio.aws.route53recoverycontrolconfig.model.primitives.{
  __stringMin12Max12PatternD12,
  __stringMin1Max64PatternS,
  __stringMin1Max256PatternAZaZ09
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Cluster(
    clusterArn: Optional[__stringMin1Max256PatternAZaZ09] = Optional.Absent,
    clusterEndpoints: Optional[
      Iterable[zio.aws.route53recoverycontrolconfig.model.ClusterEndpoint]
    ] = Optional.Absent,
    name: Optional[__stringMin1Max64PatternS] = Optional.Absent,
    status: Optional[zio.aws.route53recoverycontrolconfig.model.Status] =
      Optional.Absent,
    owner: Optional[__stringMin12Max12PatternD12] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53recoverycontrolconfig.model.Cluster = {
    import Cluster.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53recoverycontrolconfig.model.Cluster
      .builder()
      .optionallyWith(clusterArn.map(value => value: java.lang.String))(
        _.clusterArn
      )
      .optionallyWith(
        clusterEndpoints.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.clusterEndpoints)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(owner.map(value => value: java.lang.String))(_.owner)
      .build()
  }
  def asReadOnly: zio.aws.route53recoverycontrolconfig.model.Cluster.ReadOnly =
    zio.aws.route53recoverycontrolconfig.model.Cluster.wrap(buildAwsValue())
}
object Cluster {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53recoverycontrolconfig.model.Cluster
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53recoverycontrolconfig.model.Cluster =
      zio.aws.route53recoverycontrolconfig.model.Cluster(
        clusterArn.map(value => value),
        clusterEndpoints.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        name.map(value => value),
        status.map(value => value),
        owner.map(value => value)
      )
    def clusterArn: Optional[__stringMin1Max256PatternAZaZ09]
    def clusterEndpoints: Optional[
      List[zio.aws.route53recoverycontrolconfig.model.ClusterEndpoint.ReadOnly]
    ]
    def name: Optional[__stringMin1Max64PatternS]
    def status: Optional[zio.aws.route53recoverycontrolconfig.model.Status]
    def owner: Optional[__stringMin12Max12PatternD12]
    def getClusterArn: ZIO[Any, AwsError, __stringMin1Max256PatternAZaZ09] =
      AwsError.unwrapOptionField("clusterArn", clusterArn)
    def getClusterEndpoints: ZIO[Any, AwsError, List[
      zio.aws.route53recoverycontrolconfig.model.ClusterEndpoint.ReadOnly
    ]] = AwsError.unwrapOptionField("clusterEndpoints", clusterEndpoints)
    def getName: ZIO[Any, AwsError, __stringMin1Max64PatternS] =
      AwsError.unwrapOptionField("name", name)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.route53recoverycontrolconfig.model.Status
    ] = AwsError.unwrapOptionField("status", status)
    def getOwner: ZIO[Any, AwsError, __stringMin12Max12PatternD12] =
      AwsError.unwrapOptionField("owner", owner)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53recoverycontrolconfig.model.Cluster
  ) extends zio.aws.route53recoverycontrolconfig.model.Cluster.ReadOnly {
    override val clusterArn: Optional[__stringMin1Max256PatternAZaZ09] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clusterArn())
        .map(value => value: __stringMin1Max256PatternAZaZ09)
    override val clusterEndpoints: Optional[
      List[zio.aws.route53recoverycontrolconfig.model.ClusterEndpoint.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterEndpoints())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.route53recoverycontrolconfig.model.ClusterEndpoint.wrap(item)
        }.toList
      )
    override val name: Optional[__stringMin1Max64PatternS] =
      zio.aws.core.internal
        .optionalFromNullable(impl.name())
        .map(value => value: __stringMin1Max64PatternS)
    override val status
        : Optional[zio.aws.route53recoverycontrolconfig.model.Status] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.route53recoverycontrolconfig.model.Status.wrap(value)
        )
    override val owner: Optional[__stringMin12Max12PatternD12] =
      zio.aws.core.internal
        .optionalFromNullable(impl.owner())
        .map(value => value: __stringMin12Max12PatternD12)
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53recoverycontrolconfig.model.Cluster
  ): zio.aws.route53recoverycontrolconfig.model.Cluster.ReadOnly = new Wrapper(
    impl
  )
}
