package zio.aws.route53recoverycontrolconfig.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeRoutingControlResponse(
    routingControl: Optional[
      zio.aws.route53recoverycontrolconfig.model.RoutingControl
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53recoverycontrolconfig.model.DescribeRoutingControlResponse = {
    import DescribeRoutingControlResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53recoverycontrolconfig.model.DescribeRoutingControlResponse
      .builder()
      .optionallyWith(routingControl.map(value => value.buildAwsValue()))(
        _.routingControl
      )
      .build()
  }
  def asReadOnly
      : zio.aws.route53recoverycontrolconfig.model.DescribeRoutingControlResponse.ReadOnly =
    zio.aws.route53recoverycontrolconfig.model.DescribeRoutingControlResponse
      .wrap(buildAwsValue())
}
object DescribeRoutingControlResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53recoverycontrolconfig.model.DescribeRoutingControlResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.route53recoverycontrolconfig.model.DescribeRoutingControlResponse =
      zio.aws.route53recoverycontrolconfig.model.DescribeRoutingControlResponse(
        routingControl.map(value => value.asEditable)
      )
    def routingControl: Optional[
      zio.aws.route53recoverycontrolconfig.model.RoutingControl.ReadOnly
    ]
    def getRoutingControl: ZIO[
      Any,
      AwsError,
      zio.aws.route53recoverycontrolconfig.model.RoutingControl.ReadOnly
    ] = AwsError.unwrapOptionField("routingControl", routingControl)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53recoverycontrolconfig.model.DescribeRoutingControlResponse
  ) extends zio.aws.route53recoverycontrolconfig.model.DescribeRoutingControlResponse.ReadOnly {
    override val routingControl: Optional[
      zio.aws.route53recoverycontrolconfig.model.RoutingControl.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.routingControl())
      .map(value =>
        zio.aws.route53recoverycontrolconfig.model.RoutingControl.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53recoverycontrolconfig.model.DescribeRoutingControlResponse
  ): zio.aws.route53recoverycontrolconfig.model.DescribeRoutingControlResponse.ReadOnly =
    new Wrapper(impl)
}
