package zio.aws.route53recoverycontrolconfig.model
import zio.aws.route53recoverycontrolconfig.model.primitives.__stringMin1Max8096PatternS
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListClustersResponse(
    clusters: Optional[
      Iterable[zio.aws.route53recoverycontrolconfig.model.Cluster]
    ] = Optional.Absent,
    nextToken: Optional[__stringMin1Max8096PatternS] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListClustersResponse = {
    import ListClustersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListClustersResponse
      .builder()
      .optionallyWith(
        clusters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.clusters)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.route53recoverycontrolconfig.model.ListClustersResponse.ReadOnly =
    zio.aws.route53recoverycontrolconfig.model.ListClustersResponse
      .wrap(buildAwsValue())
}
object ListClustersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListClustersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.route53recoverycontrolconfig.model.ListClustersResponse =
      zio.aws.route53recoverycontrolconfig.model.ListClustersResponse(
        clusters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def clusters: Optional[
      List[zio.aws.route53recoverycontrolconfig.model.Cluster.ReadOnly]
    ]
    def nextToken: Optional[__stringMin1Max8096PatternS]
    def getClusters: ZIO[Any, AwsError, List[
      zio.aws.route53recoverycontrolconfig.model.Cluster.ReadOnly
    ]] = AwsError.unwrapOptionField("clusters", clusters)
    def getNextToken: ZIO[Any, AwsError, __stringMin1Max8096PatternS] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListClustersResponse
  ) extends zio.aws.route53recoverycontrolconfig.model.ListClustersResponse.ReadOnly {
    override val clusters: Optional[
      List[zio.aws.route53recoverycontrolconfig.model.Cluster.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.clusters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.route53recoverycontrolconfig.model.Cluster.wrap(item)
        }.toList
      )
    override val nextToken: Optional[__stringMin1Max8096PatternS] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nextToken())
        .map(value => value: __stringMin1Max8096PatternS)
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListClustersResponse
  ): zio.aws.route53recoverycontrolconfig.model.ListClustersResponse.ReadOnly =
    new Wrapper(impl)
}
