package zio.aws.route53recoverycontrolconfig.model
import zio.aws.route53recoverycontrolconfig.model.primitives.__stringMin1Max8096PatternS
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListControlPanelsResponse(
    controlPanels: Optional[
      Iterable[zio.aws.route53recoverycontrolconfig.model.ControlPanel]
    ] = Optional.Absent,
    nextToken: Optional[__stringMin1Max8096PatternS] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListControlPanelsResponse = {
    import ListControlPanelsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListControlPanelsResponse
      .builder()
      .optionallyWith(
        controlPanels.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.controlPanels)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.route53recoverycontrolconfig.model.ListControlPanelsResponse.ReadOnly =
    zio.aws.route53recoverycontrolconfig.model.ListControlPanelsResponse
      .wrap(buildAwsValue())
}
object ListControlPanelsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListControlPanelsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.route53recoverycontrolconfig.model.ListControlPanelsResponse =
      zio.aws.route53recoverycontrolconfig.model.ListControlPanelsResponse(
        controlPanels.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def controlPanels: Optional[
      List[zio.aws.route53recoverycontrolconfig.model.ControlPanel.ReadOnly]
    ]
    def nextToken: Optional[__stringMin1Max8096PatternS]
    def getControlPanels: ZIO[Any, AwsError, List[
      zio.aws.route53recoverycontrolconfig.model.ControlPanel.ReadOnly
    ]] = AwsError.unwrapOptionField("controlPanels", controlPanels)
    def getNextToken: ZIO[Any, AwsError, __stringMin1Max8096PatternS] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListControlPanelsResponse
  ) extends zio.aws.route53recoverycontrolconfig.model.ListControlPanelsResponse.ReadOnly {
    override val controlPanels: Optional[
      List[zio.aws.route53recoverycontrolconfig.model.ControlPanel.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.controlPanels())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.route53recoverycontrolconfig.model.ControlPanel.wrap(item)
        }.toList
      )
    override val nextToken: Optional[__stringMin1Max8096PatternS] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nextToken())
        .map(value => value: __stringMin1Max8096PatternS)
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListControlPanelsResponse
  ): zio.aws.route53recoverycontrolconfig.model.ListControlPanelsResponse.ReadOnly =
    new Wrapper(impl)
}
