package zio.aws.route53recoverycontrolconfig.model
import zio.aws.route53recoverycontrolconfig.model.primitives.{
  __stringMin1Max8096PatternS,
  __stringMax36PatternS
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListAssociatedRoute53HealthChecksResponse(
    healthCheckIds: Optional[Iterable[__stringMax36PatternS]] = Optional.Absent,
    nextToken: Optional[__stringMin1Max8096PatternS] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListAssociatedRoute53HealthChecksResponse = {
    import ListAssociatedRoute53HealthChecksResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListAssociatedRoute53HealthChecksResponse
      .builder()
      .optionallyWith(
        healthCheckIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.healthCheckIds)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.route53recoverycontrolconfig.model.ListAssociatedRoute53HealthChecksResponse.ReadOnly =
    zio.aws.route53recoverycontrolconfig.model.ListAssociatedRoute53HealthChecksResponse
      .wrap(buildAwsValue())
}
object ListAssociatedRoute53HealthChecksResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListAssociatedRoute53HealthChecksResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.route53recoverycontrolconfig.model.ListAssociatedRoute53HealthChecksResponse =
      zio.aws.route53recoverycontrolconfig.model
        .ListAssociatedRoute53HealthChecksResponse(
          healthCheckIds.map(value => value),
          nextToken.map(value => value)
        )
    def healthCheckIds: Optional[List[__stringMax36PatternS]]
    def nextToken: Optional[__stringMin1Max8096PatternS]
    def getHealthCheckIds: ZIO[Any, AwsError, List[__stringMax36PatternS]] =
      AwsError.unwrapOptionField("healthCheckIds", healthCheckIds)
    def getNextToken: ZIO[Any, AwsError, __stringMin1Max8096PatternS] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListAssociatedRoute53HealthChecksResponse
  ) extends zio.aws.route53recoverycontrolconfig.model.ListAssociatedRoute53HealthChecksResponse.ReadOnly {
    override val healthCheckIds: Optional[List[__stringMax36PatternS]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.healthCheckIds())
        .map(value =>
          value.asScala.map { item =>
            item: __stringMax36PatternS
          }.toList
        )
    override val nextToken: Optional[__stringMin1Max8096PatternS] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nextToken())
        .map(value => value: __stringMin1Max8096PatternS)
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListAssociatedRoute53HealthChecksResponse
  ): zio.aws.route53recoverycontrolconfig.model.ListAssociatedRoute53HealthChecksResponse.ReadOnly =
    new Wrapper(impl)
}
