package zio.aws.route53recoverycontrolconfig.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateControlPanelResponse(
    controlPanel: Optional[
      zio.aws.route53recoverycontrolconfig.model.ControlPanel
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53recoverycontrolconfig.model.CreateControlPanelResponse = {
    import CreateControlPanelResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53recoverycontrolconfig.model.CreateControlPanelResponse
      .builder()
      .optionallyWith(controlPanel.map(value => value.buildAwsValue()))(
        _.controlPanel
      )
      .build()
  }
  def asReadOnly
      : zio.aws.route53recoverycontrolconfig.model.CreateControlPanelResponse.ReadOnly =
    zio.aws.route53recoverycontrolconfig.model.CreateControlPanelResponse
      .wrap(buildAwsValue())
}
object CreateControlPanelResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53recoverycontrolconfig.model.CreateControlPanelResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.route53recoverycontrolconfig.model.CreateControlPanelResponse =
      zio.aws.route53recoverycontrolconfig.model
        .CreateControlPanelResponse(controlPanel.map(value => value.asEditable))
    def controlPanel: Optional[
      zio.aws.route53recoverycontrolconfig.model.ControlPanel.ReadOnly
    ]
    def getControlPanel: ZIO[
      Any,
      AwsError,
      zio.aws.route53recoverycontrolconfig.model.ControlPanel.ReadOnly
    ] = AwsError.unwrapOptionField("controlPanel", controlPanel)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53recoverycontrolconfig.model.CreateControlPanelResponse
  ) extends zio.aws.route53recoverycontrolconfig.model.CreateControlPanelResponse.ReadOnly {
    override val controlPanel: Optional[
      zio.aws.route53recoverycontrolconfig.model.ControlPanel.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.controlPanel())
      .map(value =>
        zio.aws.route53recoverycontrolconfig.model.ControlPanel.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53recoverycontrolconfig.model.CreateControlPanelResponse
  ): zio.aws.route53recoverycontrolconfig.model.CreateControlPanelResponse.ReadOnly =
    new Wrapper(impl)
}
