package zio.aws.route53recoverycontrolconfig.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Rule(
    assertion: Optional[
      zio.aws.route53recoverycontrolconfig.model.AssertionRule
    ] = Optional.Absent,
    gating: Optional[zio.aws.route53recoverycontrolconfig.model.GatingRule] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53recoverycontrolconfig.model.Rule = {
    import Rule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53recoverycontrolconfig.model.Rule
      .builder()
      .optionallyWith(assertion.map(value => value.buildAwsValue()))(
        _.assertion
      )
      .optionallyWith(gating.map(value => value.buildAwsValue()))(_.gating)
      .build()
  }
  def asReadOnly: zio.aws.route53recoverycontrolconfig.model.Rule.ReadOnly =
    zio.aws.route53recoverycontrolconfig.model.Rule.wrap(buildAwsValue())
}
object Rule {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53recoverycontrolconfig.model.Rule
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53recoverycontrolconfig.model.Rule =
      zio.aws.route53recoverycontrolconfig.model.Rule(
        assertion.map(value => value.asEditable),
        gating.map(value => value.asEditable)
      )
    def assertion: Optional[
      zio.aws.route53recoverycontrolconfig.model.AssertionRule.ReadOnly
    ]
    def gating: Optional[
      zio.aws.route53recoverycontrolconfig.model.GatingRule.ReadOnly
    ]
    def getAssertion: ZIO[
      Any,
      AwsError,
      zio.aws.route53recoverycontrolconfig.model.AssertionRule.ReadOnly
    ] = AwsError.unwrapOptionField("assertion", assertion)
    def getGating: ZIO[
      Any,
      AwsError,
      zio.aws.route53recoverycontrolconfig.model.GatingRule.ReadOnly
    ] = AwsError.unwrapOptionField("gating", gating)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53recoverycontrolconfig.model.Rule
  ) extends zio.aws.route53recoverycontrolconfig.model.Rule.ReadOnly {
    override val assertion: Optional[
      zio.aws.route53recoverycontrolconfig.model.AssertionRule.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.assertion())
      .map(value =>
        zio.aws.route53recoverycontrolconfig.model.AssertionRule.wrap(value)
      )
    override val gating: Optional[
      zio.aws.route53recoverycontrolconfig.model.GatingRule.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.gating())
      .map(value =>
        zio.aws.route53recoverycontrolconfig.model.GatingRule.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53recoverycontrolconfig.model.Rule
  ): zio.aws.route53recoverycontrolconfig.model.Rule.ReadOnly = new Wrapper(
    impl
  )
}
