package zio.aws.route53recoverycontrolconfig.model
import zio.aws.route53recoverycontrolconfig.model.primitives.{
  __stringMin0Max256PatternS,
  __string,
  __stringMin1Max256PatternAZaZ09,
  __stringMin1Max64PatternS
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateControlPanelRequest(
    clientToken: Optional[__stringMin1Max64PatternS] = Optional.Absent,
    clusterArn: __stringMin1Max256PatternAZaZ09,
    controlPanelName: __stringMin1Max64PatternS,
    tags: Optional[Map[__string, __stringMin0Max256PatternS]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53recoverycontrolconfig.model.CreateControlPanelRequest = {
    import CreateControlPanelRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53recoverycontrolconfig.model.CreateControlPanelRequest
      .builder()
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .clusterArn(clusterArn: java.lang.String)
      .controlPanelName(controlPanelName: java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.route53recoverycontrolconfig.model.CreateControlPanelRequest.ReadOnly =
    zio.aws.route53recoverycontrolconfig.model.CreateControlPanelRequest
      .wrap(buildAwsValue())
}
object CreateControlPanelRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53recoverycontrolconfig.model.CreateControlPanelRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.route53recoverycontrolconfig.model.CreateControlPanelRequest =
      zio.aws.route53recoverycontrolconfig.model.CreateControlPanelRequest(
        clientToken.map(value => value),
        clusterArn,
        controlPanelName,
        tags.map(value => value)
      )
    def clientToken: Optional[__stringMin1Max64PatternS]
    def clusterArn: __stringMin1Max256PatternAZaZ09
    def controlPanelName: __stringMin1Max64PatternS
    def tags: Optional[Map[__string, __stringMin0Max256PatternS]]
    def getClientToken: ZIO[Any, AwsError, __stringMin1Max64PatternS] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getClusterArn: ZIO[Any, Nothing, __stringMin1Max256PatternAZaZ09] =
      ZIO.succeed(clusterArn)
    def getControlPanelName: ZIO[Any, Nothing, __stringMin1Max64PatternS] =
      ZIO.succeed(controlPanelName)
    def getTags: ZIO[Any, AwsError, Map[__string, __stringMin0Max256PatternS]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53recoverycontrolconfig.model.CreateControlPanelRequest
  ) extends zio.aws.route53recoverycontrolconfig.model.CreateControlPanelRequest.ReadOnly {
    override val clientToken: Optional[__stringMin1Max64PatternS] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientToken())
        .map(value => value: __stringMin1Max64PatternS)
    override val clusterArn: __stringMin1Max256PatternAZaZ09 =
      impl.clusterArn(): __stringMin1Max256PatternAZaZ09
    override val controlPanelName: __stringMin1Max64PatternS =
      impl.controlPanelName(): __stringMin1Max64PatternS
    override val tags: Optional[Map[__string, __stringMin0Max256PatternS]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: __string) -> (value: __stringMin0Max256PatternS)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53recoverycontrolconfig.model.CreateControlPanelRequest
  ): zio.aws.route53recoverycontrolconfig.model.CreateControlPanelRequest.ReadOnly =
    new Wrapper(impl)
}
