package zio.aws.route53recoverycontrolconfig
import zio.aws.route53recoverycontrolconfig.model.ListAssociatedRoute53HealthChecksResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import software.amazon.awssdk.services.route53recoverycontrolconfig.Route53RecoveryControlConfigAsyncClient
import zio.aws.route53recoverycontrolconfig.model.primitives.__stringMax36PatternS
import zio.aws.route53recoverycontrolconfig.model.{
  DeleteSafetyRuleRequest,
  DescribeControlPanelRequest,
  CreateControlPanelRequest,
  UpdateSafetyRuleRequest,
  UpdateRoutingControlRequest,
  ListTagsForResourceRequest,
  DeleteControlPanelRequest,
  UpdateControlPanelRequest,
  CreateClusterRequest,
  ListRoutingControlsRequest,
  DeleteClusterRequest,
  ListAssociatedRoute53HealthChecksRequest,
  ListSafetyRulesRequest,
  CreateRoutingControlRequest,
  UntagResourceRequest,
  ListControlPanelsRequest,
  DescribeSafetyRuleRequest,
  DescribeClusterRequest,
  DescribeRoutingControlRequest,
  ListClustersRequest,
  TagResourceRequest,
  CreateSafetyRuleRequest,
  DeleteRoutingControlRequest
}
import zio.stream.ZStream
object Route53RecoveryControlConfigMock
    extends Mock[Route53RecoveryControlConfig] {
  object DescribeSafetyRule
      extends Effect[
        DescribeSafetyRuleRequest,
        AwsError,
        zio.aws.route53recoverycontrolconfig.model.DescribeSafetyRuleResponse.ReadOnly
      ]
  object UpdateSafetyRule
      extends Effect[
        UpdateSafetyRuleRequest,
        AwsError,
        zio.aws.route53recoverycontrolconfig.model.UpdateSafetyRuleResponse.ReadOnly
      ]
  object ListControlPanels
      extends Stream[
        ListControlPanelsRequest,
        AwsError,
        zio.aws.route53recoverycontrolconfig.model.ControlPanel.ReadOnly
      ]
  object ListControlPanelsPaginated
      extends Effect[
        ListControlPanelsRequest,
        AwsError,
        zio.aws.route53recoverycontrolconfig.model.ListControlPanelsResponse.ReadOnly
      ]
  object DescribeControlPanel
      extends Effect[
        DescribeControlPanelRequest,
        AwsError,
        zio.aws.route53recoverycontrolconfig.model.DescribeControlPanelResponse.ReadOnly
      ]
  object DeleteRoutingControl
      extends Effect[
        DeleteRoutingControlRequest,
        AwsError,
        zio.aws.route53recoverycontrolconfig.model.DeleteRoutingControlResponse.ReadOnly
      ]
  object CreateRoutingControl
      extends Effect[
        CreateRoutingControlRequest,
        AwsError,
        zio.aws.route53recoverycontrolconfig.model.CreateRoutingControlResponse.ReadOnly
      ]
  object CreateCluster
      extends Effect[
        CreateClusterRequest,
        AwsError,
        zio.aws.route53recoverycontrolconfig.model.CreateClusterResponse.ReadOnly
      ]
  object DeleteCluster
      extends Effect[
        DeleteClusterRequest,
        AwsError,
        zio.aws.route53recoverycontrolconfig.model.DeleteClusterResponse.ReadOnly
      ]
  object CreateSafetyRule
      extends Effect[
        CreateSafetyRuleRequest,
        AwsError,
        zio.aws.route53recoverycontrolconfig.model.CreateSafetyRuleResponse.ReadOnly
      ]
  object ListSafetyRules
      extends Stream[
        ListSafetyRulesRequest,
        AwsError,
        zio.aws.route53recoverycontrolconfig.model.Rule.ReadOnly
      ]
  object ListSafetyRulesPaginated
      extends Effect[
        ListSafetyRulesRequest,
        AwsError,
        zio.aws.route53recoverycontrolconfig.model.ListSafetyRulesResponse.ReadOnly
      ]
  object ListRoutingControls
      extends Stream[
        ListRoutingControlsRequest,
        AwsError,
        zio.aws.route53recoverycontrolconfig.model.RoutingControl.ReadOnly
      ]
  object ListRoutingControlsPaginated
      extends Effect[
        ListRoutingControlsRequest,
        AwsError,
        zio.aws.route53recoverycontrolconfig.model.ListRoutingControlsResponse.ReadOnly
      ]
  object ListAssociatedRoute53HealthChecks
      extends Stream[
        ListAssociatedRoute53HealthChecksRequest,
        AwsError,
        __stringMax36PatternS
      ]
  object ListAssociatedRoute53HealthChecksPaginated
      extends Effect[
        ListAssociatedRoute53HealthChecksRequest,
        AwsError,
        ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.route53recoverycontrolconfig.model.UntagResourceResponse.ReadOnly
      ]
  object DescribeRoutingControl
      extends Effect[
        DescribeRoutingControlRequest,
        AwsError,
        zio.aws.route53recoverycontrolconfig.model.DescribeRoutingControlResponse.ReadOnly
      ]
  object DescribeCluster
      extends Effect[
        DescribeClusterRequest,
        AwsError,
        zio.aws.route53recoverycontrolconfig.model.DescribeClusterResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.route53recoverycontrolconfig.model.ListTagsForResourceResponse.ReadOnly
      ]
  object ListClusters
      extends Stream[
        ListClustersRequest,
        AwsError,
        zio.aws.route53recoverycontrolconfig.model.Cluster.ReadOnly
      ]
  object ListClustersPaginated
      extends Effect[
        ListClustersRequest,
        AwsError,
        zio.aws.route53recoverycontrolconfig.model.ListClustersResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.route53recoverycontrolconfig.model.TagResourceResponse.ReadOnly
      ]
  object UpdateControlPanel
      extends Effect[
        UpdateControlPanelRequest,
        AwsError,
        zio.aws.route53recoverycontrolconfig.model.UpdateControlPanelResponse.ReadOnly
      ]
  object CreateControlPanel
      extends Effect[
        CreateControlPanelRequest,
        AwsError,
        zio.aws.route53recoverycontrolconfig.model.CreateControlPanelResponse.ReadOnly
      ]
  object DeleteSafetyRule
      extends Effect[
        DeleteSafetyRuleRequest,
        AwsError,
        zio.aws.route53recoverycontrolconfig.model.DeleteSafetyRuleResponse.ReadOnly
      ]
  object DeleteControlPanel
      extends Effect[
        DeleteControlPanelRequest,
        AwsError,
        zio.aws.route53recoverycontrolconfig.model.DeleteControlPanelResponse.ReadOnly
      ]
  object UpdateRoutingControl
      extends Effect[
        UpdateRoutingControlRequest,
        AwsError,
        zio.aws.route53recoverycontrolconfig.model.UpdateRoutingControlResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, Route53RecoveryControlConfig] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, Route53RecoveryControlConfig] { rts =>
        zio.ZIO.succeed {
          new Route53RecoveryControlConfig {
            val api: Route53RecoveryControlConfigAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): Route53RecoveryControlConfig = this
            def describeSafetyRule(request: DescribeSafetyRuleRequest): IO[
              AwsError,
              zio.aws.route53recoverycontrolconfig.model.DescribeSafetyRuleResponse.ReadOnly
            ] = proxy(DescribeSafetyRule, request)
            def updateSafetyRule(request: UpdateSafetyRuleRequest): IO[
              AwsError,
              zio.aws.route53recoverycontrolconfig.model.UpdateSafetyRuleResponse.ReadOnly
            ] = proxy(UpdateSafetyRule, request)
            def listControlPanels(request: ListControlPanelsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.route53recoverycontrolconfig.model.ControlPanel.ReadOnly
            ] = rts.unsafeRun(proxy(ListControlPanels, request))
            def listControlPanelsPaginated(
                request: ListControlPanelsRequest
            ): IO[
              AwsError,
              zio.aws.route53recoverycontrolconfig.model.ListControlPanelsResponse.ReadOnly
            ] = proxy(ListControlPanelsPaginated, request)
            def describeControlPanel(request: DescribeControlPanelRequest): IO[
              AwsError,
              zio.aws.route53recoverycontrolconfig.model.DescribeControlPanelResponse.ReadOnly
            ] = proxy(DescribeControlPanel, request)
            def deleteRoutingControl(request: DeleteRoutingControlRequest): IO[
              AwsError,
              zio.aws.route53recoverycontrolconfig.model.DeleteRoutingControlResponse.ReadOnly
            ] = proxy(DeleteRoutingControl, request)
            def createRoutingControl(request: CreateRoutingControlRequest): IO[
              AwsError,
              zio.aws.route53recoverycontrolconfig.model.CreateRoutingControlResponse.ReadOnly
            ] = proxy(CreateRoutingControl, request)
            def createCluster(request: CreateClusterRequest): IO[
              AwsError,
              zio.aws.route53recoverycontrolconfig.model.CreateClusterResponse.ReadOnly
            ] = proxy(CreateCluster, request)
            def deleteCluster(request: DeleteClusterRequest): IO[
              AwsError,
              zio.aws.route53recoverycontrolconfig.model.DeleteClusterResponse.ReadOnly
            ] = proxy(DeleteCluster, request)
            def createSafetyRule(request: CreateSafetyRuleRequest): IO[
              AwsError,
              zio.aws.route53recoverycontrolconfig.model.CreateSafetyRuleResponse.ReadOnly
            ] = proxy(CreateSafetyRule, request)
            def listSafetyRules(request: ListSafetyRulesRequest): ZStream[
              Any,
              AwsError,
              zio.aws.route53recoverycontrolconfig.model.Rule.ReadOnly
            ] = rts.unsafeRun(proxy(ListSafetyRules, request))
            def listSafetyRulesPaginated(request: ListSafetyRulesRequest): IO[
              AwsError,
              zio.aws.route53recoverycontrolconfig.model.ListSafetyRulesResponse.ReadOnly
            ] = proxy(ListSafetyRulesPaginated, request)
            def listRoutingControls(
                request: ListRoutingControlsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.route53recoverycontrolconfig.model.RoutingControl.ReadOnly
            ] = rts.unsafeRun(proxy(ListRoutingControls, request))
            def listRoutingControlsPaginated(
                request: ListRoutingControlsRequest
            ): IO[
              AwsError,
              zio.aws.route53recoverycontrolconfig.model.ListRoutingControlsResponse.ReadOnly
            ] = proxy(ListRoutingControlsPaginated, request)
            def listAssociatedRoute53HealthChecks(
                request: ListAssociatedRoute53HealthChecksRequest
            ): ZStream[Any, AwsError, __stringMax36PatternS] =
              rts.unsafeRun(proxy(ListAssociatedRoute53HealthChecks, request))
            def listAssociatedRoute53HealthChecksPaginated(
                request: ListAssociatedRoute53HealthChecksRequest
            ): IO[AwsError, ReadOnly] =
              proxy(ListAssociatedRoute53HealthChecksPaginated, request)
            def untagResource(request: UntagResourceRequest): IO[
              AwsError,
              zio.aws.route53recoverycontrolconfig.model.UntagResourceResponse.ReadOnly
            ] = proxy(UntagResource, request)
            def describeRoutingControl(
                request: DescribeRoutingControlRequest
            ): IO[
              AwsError,
              zio.aws.route53recoverycontrolconfig.model.DescribeRoutingControlResponse.ReadOnly
            ] = proxy(DescribeRoutingControl, request)
            def describeCluster(request: DescribeClusterRequest): IO[
              AwsError,
              zio.aws.route53recoverycontrolconfig.model.DescribeClusterResponse.ReadOnly
            ] = proxy(DescribeCluster, request)
            def listTagsForResource(request: ListTagsForResourceRequest): IO[
              AwsError,
              zio.aws.route53recoverycontrolconfig.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResource, request)
            def listClusters(request: ListClustersRequest): ZStream[
              Any,
              AwsError,
              zio.aws.route53recoverycontrolconfig.model.Cluster.ReadOnly
            ] = rts.unsafeRun(proxy(ListClusters, request))
            def listClustersPaginated(request: ListClustersRequest): IO[
              AwsError,
              zio.aws.route53recoverycontrolconfig.model.ListClustersResponse.ReadOnly
            ] = proxy(ListClustersPaginated, request)
            def tagResource(request: TagResourceRequest): IO[
              AwsError,
              zio.aws.route53recoverycontrolconfig.model.TagResourceResponse.ReadOnly
            ] = proxy(TagResource, request)
            def updateControlPanel(request: UpdateControlPanelRequest): IO[
              AwsError,
              zio.aws.route53recoverycontrolconfig.model.UpdateControlPanelResponse.ReadOnly
            ] = proxy(UpdateControlPanel, request)
            def createControlPanel(request: CreateControlPanelRequest): IO[
              AwsError,
              zio.aws.route53recoverycontrolconfig.model.CreateControlPanelResponse.ReadOnly
            ] = proxy(CreateControlPanel, request)
            def deleteSafetyRule(request: DeleteSafetyRuleRequest): IO[
              AwsError,
              zio.aws.route53recoverycontrolconfig.model.DeleteSafetyRuleResponse.ReadOnly
            ] = proxy(DeleteSafetyRule, request)
            def deleteControlPanel(request: DeleteControlPanelRequest): IO[
              AwsError,
              zio.aws.route53recoverycontrolconfig.model.DeleteControlPanelResponse.ReadOnly
            ] = proxy(DeleteControlPanel, request)
            def updateRoutingControl(request: UpdateRoutingControlRequest): IO[
              AwsError,
              zio.aws.route53recoverycontrolconfig.model.UpdateRoutingControlResponse.ReadOnly
            ] = proxy(UpdateRoutingControl, request)
          }
        }
      }
    }
  }
}
