package zio.aws.route53recoverycontrolconfig.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.route53recoverycontrolconfig.model.primitives.{
  MaxResults,
  __string
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListSafetyRulesRequest(
    controlPanelArn: __string,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListSafetyRulesRequest = {
    import ListSafetyRulesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListSafetyRulesRequest
      .builder()
      .controlPanelArn(controlPanelArn: java.lang.String)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.route53recoverycontrolconfig.model.ListSafetyRulesRequest.ReadOnly =
    zio.aws.route53recoverycontrolconfig.model.ListSafetyRulesRequest
      .wrap(buildAwsValue())
}
object ListSafetyRulesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListSafetyRulesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.route53recoverycontrolconfig.model.ListSafetyRulesRequest =
      zio.aws.route53recoverycontrolconfig.model.ListSafetyRulesRequest(
        controlPanelArn,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def controlPanelArn: __string
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[__string]
    def getControlPanelArn: ZIO[Any, Nothing, __string] =
      ZIO.succeed(controlPanelArn)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListSafetyRulesRequest
  ) extends zio.aws.route53recoverycontrolconfig.model.ListSafetyRulesRequest.ReadOnly {
    override val controlPanelArn: __string = impl.controlPanelArn(): __string
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value =>
        zio.aws.route53recoverycontrolconfig.model.primitives.MaxResults(value)
      )
    override val nextToken: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListSafetyRulesRequest
  ): zio.aws.route53recoverycontrolconfig.model.ListSafetyRulesRequest.ReadOnly =
    new Wrapper(impl)
}
