package zio.aws.route53recoverycontrolconfig.model
import zio.aws.route53recoverycontrolconfig.model.primitives.{
  __stringMin1Max32PatternS,
  __stringMin1Max128PatternAZaZ09
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ClusterEndpoint(
    endpoint: Optional[__stringMin1Max128PatternAZaZ09] = Optional.Absent,
    region: Optional[__stringMin1Max32PatternS] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53recoverycontrolconfig.model.ClusterEndpoint = {
    import ClusterEndpoint.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53recoverycontrolconfig.model.ClusterEndpoint
      .builder()
      .optionallyWith(endpoint.map(value => value: java.lang.String))(
        _.endpoint
      )
      .optionallyWith(region.map(value => value: java.lang.String))(_.region)
      .build()
  }
  def asReadOnly
      : zio.aws.route53recoverycontrolconfig.model.ClusterEndpoint.ReadOnly =
    zio.aws.route53recoverycontrolconfig.model.ClusterEndpoint
      .wrap(buildAwsValue())
}
object ClusterEndpoint {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53recoverycontrolconfig.model.ClusterEndpoint
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53recoverycontrolconfig.model.ClusterEndpoint =
      zio.aws.route53recoverycontrolconfig.model.ClusterEndpoint(
        endpoint.map(value => value),
        region.map(value => value)
      )
    def endpoint: Optional[__stringMin1Max128PatternAZaZ09]
    def region: Optional[__stringMin1Max32PatternS]
    def getEndpoint: ZIO[Any, AwsError, __stringMin1Max128PatternAZaZ09] =
      AwsError.unwrapOptionField("endpoint", endpoint)
    def getRegion: ZIO[Any, AwsError, __stringMin1Max32PatternS] =
      AwsError.unwrapOptionField("region", region)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53recoverycontrolconfig.model.ClusterEndpoint
  ) extends zio.aws.route53recoverycontrolconfig.model.ClusterEndpoint.ReadOnly {
    override val endpoint: Optional[__stringMin1Max128PatternAZaZ09] =
      zio.aws.core.internal
        .optionalFromNullable(impl.endpoint())
        .map(value => value: __stringMin1Max128PatternAZaZ09)
    override val region: Optional[__stringMin1Max32PatternS] =
      zio.aws.core.internal
        .optionalFromNullable(impl.region())
        .map(value => value: __stringMin1Max32PatternS)
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53recoverycontrolconfig.model.ClusterEndpoint
  ): zio.aws.route53recoverycontrolconfig.model.ClusterEndpoint.ReadOnly =
    new Wrapper(impl)
}
