package zio.aws.route53recoverycontrolconfig.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateRoutingControlResponse(
    routingControl: Optional[
      zio.aws.route53recoverycontrolconfig.model.RoutingControl
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53recoverycontrolconfig.model.UpdateRoutingControlResponse = {
    import UpdateRoutingControlResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53recoverycontrolconfig.model.UpdateRoutingControlResponse
      .builder()
      .optionallyWith(routingControl.map(value => value.buildAwsValue()))(
        _.routingControl
      )
      .build()
  }
  def asReadOnly
      : zio.aws.route53recoverycontrolconfig.model.UpdateRoutingControlResponse.ReadOnly =
    zio.aws.route53recoverycontrolconfig.model.UpdateRoutingControlResponse
      .wrap(buildAwsValue())
}
object UpdateRoutingControlResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53recoverycontrolconfig.model.UpdateRoutingControlResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.route53recoverycontrolconfig.model.UpdateRoutingControlResponse =
      zio.aws.route53recoverycontrolconfig.model.UpdateRoutingControlResponse(
        routingControl.map(value => value.asEditable)
      )
    def routingControl: Optional[
      zio.aws.route53recoverycontrolconfig.model.RoutingControl.ReadOnly
    ]
    def getRoutingControl: ZIO[
      Any,
      AwsError,
      zio.aws.route53recoverycontrolconfig.model.RoutingControl.ReadOnly
    ] = AwsError.unwrapOptionField("routingControl", routingControl)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53recoverycontrolconfig.model.UpdateRoutingControlResponse
  ) extends zio.aws.route53recoverycontrolconfig.model.UpdateRoutingControlResponse.ReadOnly {
    override val routingControl: Optional[
      zio.aws.route53recoverycontrolconfig.model.RoutingControl.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.routingControl())
      .map(value =>
        zio.aws.route53recoverycontrolconfig.model.RoutingControl.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53recoverycontrolconfig.model.UpdateRoutingControlResponse
  ): zio.aws.route53recoverycontrolconfig.model.UpdateRoutingControlResponse.ReadOnly =
    new Wrapper(impl)
}
