package zio.aws.route53recoverycontrolconfig.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeControlPanelResponse(
    controlPanel: Option[
      zio.aws.route53recoverycontrolconfig.model.ControlPanel
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53recoverycontrolconfig.model.DescribeControlPanelResponse = {
    import DescribeControlPanelResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53recoverycontrolconfig.model.DescribeControlPanelResponse
      .builder()
      .optionallyWith(controlPanel.map(value => value.buildAwsValue()))(
        _.controlPanel
      )
      .build()
  }
  def asReadOnly
      : zio.aws.route53recoverycontrolconfig.model.DescribeControlPanelResponse.ReadOnly =
    zio.aws.route53recoverycontrolconfig.model.DescribeControlPanelResponse
      .wrap(buildAwsValue())
}
object DescribeControlPanelResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53recoverycontrolconfig.model.DescribeControlPanelResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.route53recoverycontrolconfig.model.DescribeControlPanelResponse =
      zio.aws.route53recoverycontrolconfig.model.DescribeControlPanelResponse(
        controlPanel.map(value => value.asEditable)
      )
    def controlPanel: Option[
      zio.aws.route53recoverycontrolconfig.model.ControlPanel.ReadOnly
    ]
    def getControlPanel: ZIO[
      Any,
      AwsError,
      zio.aws.route53recoverycontrolconfig.model.ControlPanel.ReadOnly
    ] = AwsError.unwrapOptionField("controlPanel", controlPanel)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53recoverycontrolconfig.model.DescribeControlPanelResponse
  ) extends zio.aws.route53recoverycontrolconfig.model.DescribeControlPanelResponse.ReadOnly {
    override val controlPanel: Option[
      zio.aws.route53recoverycontrolconfig.model.ControlPanel.ReadOnly
    ] = scala
      .Option(impl.controlPanel())
      .map(value =>
        zio.aws.route53recoverycontrolconfig.model.ControlPanel.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53recoverycontrolconfig.model.DescribeControlPanelResponse
  ): zio.aws.route53recoverycontrolconfig.model.DescribeControlPanelResponse.ReadOnly =
    new Wrapper(impl)
}
