package zio.aws.route53recoverycontrolconfig.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateSafetyRuleRequest(
    assertionRuleUpdate: Option[
      zio.aws.route53recoverycontrolconfig.model.AssertionRuleUpdate
    ] = None,
    gatingRuleUpdate: Option[
      zio.aws.route53recoverycontrolconfig.model.GatingRuleUpdate
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53recoverycontrolconfig.model.UpdateSafetyRuleRequest = {
    import UpdateSafetyRuleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53recoverycontrolconfig.model.UpdateSafetyRuleRequest
      .builder()
      .optionallyWith(assertionRuleUpdate.map(value => value.buildAwsValue()))(
        _.assertionRuleUpdate
      )
      .optionallyWith(gatingRuleUpdate.map(value => value.buildAwsValue()))(
        _.gatingRuleUpdate
      )
      .build()
  }
  def asReadOnly
      : zio.aws.route53recoverycontrolconfig.model.UpdateSafetyRuleRequest.ReadOnly =
    zio.aws.route53recoverycontrolconfig.model.UpdateSafetyRuleRequest
      .wrap(buildAwsValue())
}
object UpdateSafetyRuleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53recoverycontrolconfig.model.UpdateSafetyRuleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.route53recoverycontrolconfig.model.UpdateSafetyRuleRequest =
      zio.aws.route53recoverycontrolconfig.model.UpdateSafetyRuleRequest(
        assertionRuleUpdate.map(value => value.asEditable),
        gatingRuleUpdate.map(value => value.asEditable)
      )
    def assertionRuleUpdate: Option[
      zio.aws.route53recoverycontrolconfig.model.AssertionRuleUpdate.ReadOnly
    ]
    def gatingRuleUpdate: Option[
      zio.aws.route53recoverycontrolconfig.model.GatingRuleUpdate.ReadOnly
    ]
    def getAssertionRuleUpdate: ZIO[
      Any,
      AwsError,
      zio.aws.route53recoverycontrolconfig.model.AssertionRuleUpdate.ReadOnly
    ] = AwsError.unwrapOptionField("assertionRuleUpdate", assertionRuleUpdate)
    def getGatingRuleUpdate: ZIO[
      Any,
      AwsError,
      zio.aws.route53recoverycontrolconfig.model.GatingRuleUpdate.ReadOnly
    ] = AwsError.unwrapOptionField("gatingRuleUpdate", gatingRuleUpdate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53recoverycontrolconfig.model.UpdateSafetyRuleRequest
  ) extends zio.aws.route53recoverycontrolconfig.model.UpdateSafetyRuleRequest.ReadOnly {
    override val assertionRuleUpdate: Option[
      zio.aws.route53recoverycontrolconfig.model.AssertionRuleUpdate.ReadOnly
    ] = scala
      .Option(impl.assertionRuleUpdate())
      .map(value =>
        zio.aws.route53recoverycontrolconfig.model.AssertionRuleUpdate
          .wrap(value)
      )
    override val gatingRuleUpdate: Option[
      zio.aws.route53recoverycontrolconfig.model.GatingRuleUpdate.ReadOnly
    ] = scala
      .Option(impl.gatingRuleUpdate())
      .map(value =>
        zio.aws.route53recoverycontrolconfig.model.GatingRuleUpdate.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53recoverycontrolconfig.model.UpdateSafetyRuleRequest
  ): zio.aws.route53recoverycontrolconfig.model.UpdateSafetyRuleRequest.ReadOnly =
    new Wrapper(impl)
}
