package zio.aws.route53recoverycontrolconfig.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeClusterResponse(
    cluster: Option[zio.aws.route53recoverycontrolconfig.model.Cluster] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53recoverycontrolconfig.model.DescribeClusterResponse = {
    import DescribeClusterResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53recoverycontrolconfig.model.DescribeClusterResponse
      .builder()
      .optionallyWith(cluster.map(value => value.buildAwsValue()))(_.cluster)
      .build()
  }
  def asReadOnly
      : zio.aws.route53recoverycontrolconfig.model.DescribeClusterResponse.ReadOnly =
    zio.aws.route53recoverycontrolconfig.model.DescribeClusterResponse
      .wrap(buildAwsValue())
}
object DescribeClusterResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53recoverycontrolconfig.model.DescribeClusterResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.route53recoverycontrolconfig.model.DescribeClusterResponse =
      zio.aws.route53recoverycontrolconfig.model
        .DescribeClusterResponse(cluster.map(value => value.asEditable))
    def cluster
        : Option[zio.aws.route53recoverycontrolconfig.model.Cluster.ReadOnly]
    def getCluster: ZIO[
      Any,
      AwsError,
      zio.aws.route53recoverycontrolconfig.model.Cluster.ReadOnly
    ] = AwsError.unwrapOptionField("cluster", cluster)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53recoverycontrolconfig.model.DescribeClusterResponse
  ) extends zio.aws.route53recoverycontrolconfig.model.DescribeClusterResponse.ReadOnly {
    override val cluster
        : Option[zio.aws.route53recoverycontrolconfig.model.Cluster.ReadOnly] =
      scala
        .Option(impl.cluster())
        .map(value =>
          zio.aws.route53recoverycontrolconfig.model.Cluster.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53recoverycontrolconfig.model.DescribeClusterResponse
  ): zio.aws.route53recoverycontrolconfig.model.DescribeClusterResponse.ReadOnly =
    new Wrapper(impl)
}
