package zio.aws.route53recoverycontrolconfig.model
import zio.aws.route53recoverycontrolconfig.model.primitives.__stringMin1Max8096PatternS
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListSafetyRulesResponse(
    nextToken: Option[__stringMin1Max8096PatternS] = None,
    safetyRules: Option[
      Iterable[zio.aws.route53recoverycontrolconfig.model.Rule]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListSafetyRulesResponse = {
    import ListSafetyRulesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListSafetyRulesResponse
      .builder()
      .optionallyWith(
        nextToken.map(value =>
          __stringMin1Max8096PatternS.unwrap(value): java.lang.String
        )
      )(_.nextToken)
      .optionallyWith(
        safetyRules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.safetyRules)
      .build()
  }
  def asReadOnly
      : zio.aws.route53recoverycontrolconfig.model.ListSafetyRulesResponse.ReadOnly =
    zio.aws.route53recoverycontrolconfig.model.ListSafetyRulesResponse
      .wrap(buildAwsValue())
}
object ListSafetyRulesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListSafetyRulesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.route53recoverycontrolconfig.model.ListSafetyRulesResponse =
      zio.aws.route53recoverycontrolconfig.model.ListSafetyRulesResponse(
        nextToken.map(value => value),
        safetyRules.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Option[__stringMin1Max8096PatternS]
    def safetyRules
        : Option[List[zio.aws.route53recoverycontrolconfig.model.Rule.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, __stringMin1Max8096PatternS] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSafetyRules: ZIO[Any, AwsError, List[
      zio.aws.route53recoverycontrolconfig.model.Rule.ReadOnly
    ]] = AwsError.unwrapOptionField("safetyRules", safetyRules)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListSafetyRulesResponse
  ) extends zio.aws.route53recoverycontrolconfig.model.ListSafetyRulesResponse.ReadOnly {
    override val nextToken: Option[__stringMin1Max8096PatternS] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.route53recoverycontrolconfig.model.primitives
          .__stringMin1Max8096PatternS(value)
      )
    override val safetyRules: Option[
      List[zio.aws.route53recoverycontrolconfig.model.Rule.ReadOnly]
    ] = scala
      .Option(impl.safetyRules())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.route53recoverycontrolconfig.model.Rule.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListSafetyRulesResponse
  ): zio.aws.route53recoverycontrolconfig.model.ListSafetyRulesResponse.ReadOnly =
    new Wrapper(impl)
}
