package zio.aws.route53recoverycontrolconfig.model
import zio.aws.route53recoverycontrolconfig.model.primitives.{
  __stringMin0Max256PatternS,
  __string,
  __stringMin1Max64PatternS
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateClusterRequest(
    clientToken: Option[__stringMin1Max64PatternS] = None,
    clusterName: __stringMin1Max64PatternS,
    tags: Option[Map[__string, __stringMin0Max256PatternS]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53recoverycontrolconfig.model.CreateClusterRequest = {
    import CreateClusterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53recoverycontrolconfig.model.CreateClusterRequest
      .builder()
      .optionallyWith(
        clientToken.map(value =>
          __stringMin1Max64PatternS.unwrap(value): java.lang.String
        )
      )(_.clientToken)
      .clusterName(
        __stringMin1Max64PatternS.unwrap(clusterName): java.lang.String
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (__string
                .unwrap(key): java.lang.String) -> (__stringMin0Max256PatternS
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.route53recoverycontrolconfig.model.CreateClusterRequest.ReadOnly =
    zio.aws.route53recoverycontrolconfig.model.CreateClusterRequest
      .wrap(buildAwsValue())
}
object CreateClusterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53recoverycontrolconfig.model.CreateClusterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.route53recoverycontrolconfig.model.CreateClusterRequest =
      zio.aws.route53recoverycontrolconfig.model.CreateClusterRequest(
        clientToken.map(value => value),
        clusterName,
        tags.map(value => value)
      )
    def clientToken: Option[__stringMin1Max64PatternS]
    def clusterName: __stringMin1Max64PatternS
    def tags: Option[Map[__string, __stringMin0Max256PatternS]]
    def getClientToken: ZIO[Any, AwsError, __stringMin1Max64PatternS] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getClusterName: ZIO[Any, Nothing, __stringMin1Max64PatternS] =
      ZIO.succeed(clusterName)
    def getTags: ZIO[Any, AwsError, Map[__string, __stringMin0Max256PatternS]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53recoverycontrolconfig.model.CreateClusterRequest
  ) extends zio.aws.route53recoverycontrolconfig.model.CreateClusterRequest.ReadOnly {
    override val clientToken: Option[__stringMin1Max64PatternS] = scala
      .Option(impl.clientToken())
      .map(value =>
        zio.aws.route53recoverycontrolconfig.model.primitives
          .__stringMin1Max64PatternS(value)
      )
    override val clusterName: __stringMin1Max64PatternS =
      zio.aws.route53recoverycontrolconfig.model.primitives
        .__stringMin1Max64PatternS(impl.clusterName())
    override val tags: Option[Map[__string, __stringMin0Max256PatternS]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.route53recoverycontrolconfig.model.primitives.__string(
              key
            ) -> zio.aws.route53recoverycontrolconfig.model.primitives
              .__stringMin0Max256PatternS(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53recoverycontrolconfig.model.CreateClusterRequest
  ): zio.aws.route53recoverycontrolconfig.model.CreateClusterRequest.ReadOnly =
    new Wrapper(impl)
}
