package zio.aws.route53recoverycontrolconfig.model
import java.lang.Integer
import zio.aws.route53recoverycontrolconfig.model.primitives.{
  __integer,
  __stringMin1Max64PatternS,
  __boolean,
  __stringMin1Max256PatternAZaZ09
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ControlPanel(
    clusterArn: Option[__stringMin1Max256PatternAZaZ09] = None,
    controlPanelArn: Option[__stringMin1Max256PatternAZaZ09] = None,
    defaultControlPanel: Option[__boolean] = None,
    name: Option[__stringMin1Max64PatternS] = None,
    routingControlCount: Option[__integer] = None,
    status: Option[zio.aws.route53recoverycontrolconfig.model.Status] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53recoverycontrolconfig.model.ControlPanel = {
    import ControlPanel.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53recoverycontrolconfig.model.ControlPanel
      .builder()
      .optionallyWith(
        clusterArn.map(value =>
          __stringMin1Max256PatternAZaZ09.unwrap(value): java.lang.String
        )
      )(_.clusterArn)
      .optionallyWith(
        controlPanelArn.map(value =>
          __stringMin1Max256PatternAZaZ09.unwrap(value): java.lang.String
        )
      )(_.controlPanelArn)
      .optionallyWith(
        defaultControlPanel.map(value =>
          __boolean.unwrap(value): java.lang.Boolean
        )
      )(_.defaultControlPanel)
      .optionallyWith(
        name.map(value =>
          __stringMin1Max64PatternS.unwrap(value): java.lang.String
        )
      )(_.name)
      .optionallyWith(
        routingControlCount.map(value => __integer.unwrap(value): Integer)
      )(_.routingControlCount)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly
      : zio.aws.route53recoverycontrolconfig.model.ControlPanel.ReadOnly =
    zio.aws.route53recoverycontrolconfig.model.ControlPanel
      .wrap(buildAwsValue())
}
object ControlPanel {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53recoverycontrolconfig.model.ControlPanel
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53recoverycontrolconfig.model.ControlPanel =
      zio.aws.route53recoverycontrolconfig.model.ControlPanel(
        clusterArn.map(value => value),
        controlPanelArn.map(value => value),
        defaultControlPanel.map(value => value),
        name.map(value => value),
        routingControlCount.map(value => value),
        status.map(value => value)
      )
    def clusterArn: Option[__stringMin1Max256PatternAZaZ09]
    def controlPanelArn: Option[__stringMin1Max256PatternAZaZ09]
    def defaultControlPanel: Option[__boolean]
    def name: Option[__stringMin1Max64PatternS]
    def routingControlCount: Option[__integer]
    def status: Option[zio.aws.route53recoverycontrolconfig.model.Status]
    def getClusterArn: ZIO[Any, AwsError, __stringMin1Max256PatternAZaZ09] =
      AwsError.unwrapOptionField("clusterArn", clusterArn)
    def getControlPanelArn
        : ZIO[Any, AwsError, __stringMin1Max256PatternAZaZ09] =
      AwsError.unwrapOptionField("controlPanelArn", controlPanelArn)
    def getDefaultControlPanel: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("defaultControlPanel", defaultControlPanel)
    def getName: ZIO[Any, AwsError, __stringMin1Max64PatternS] =
      AwsError.unwrapOptionField("name", name)
    def getRoutingControlCount: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("routingControlCount", routingControlCount)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.route53recoverycontrolconfig.model.Status
    ] = AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53recoverycontrolconfig.model.ControlPanel
  ) extends zio.aws.route53recoverycontrolconfig.model.ControlPanel.ReadOnly {
    override val clusterArn: Option[__stringMin1Max256PatternAZaZ09] = scala
      .Option(impl.clusterArn())
      .map(value =>
        zio.aws.route53recoverycontrolconfig.model.primitives
          .__stringMin1Max256PatternAZaZ09(value)
      )
    override val controlPanelArn: Option[__stringMin1Max256PatternAZaZ09] =
      scala
        .Option(impl.controlPanelArn())
        .map(value =>
          zio.aws.route53recoverycontrolconfig.model.primitives
            .__stringMin1Max256PatternAZaZ09(value)
        )
    override val defaultControlPanel: Option[__boolean] = scala
      .Option(impl.defaultControlPanel())
      .map(value =>
        zio.aws.route53recoverycontrolconfig.model.primitives.__boolean(value)
      )
    override val name: Option[__stringMin1Max64PatternS] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.route53recoverycontrolconfig.model.primitives
          .__stringMin1Max64PatternS(value)
      )
    override val routingControlCount: Option[__integer] = scala
      .Option(impl.routingControlCount())
      .map(value =>
        zio.aws.route53recoverycontrolconfig.model.primitives.__integer(value)
      )
    override val status
        : Option[zio.aws.route53recoverycontrolconfig.model.Status] = scala
      .Option(impl.status())
      .map(value =>
        zio.aws.route53recoverycontrolconfig.model.Status.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53recoverycontrolconfig.model.ControlPanel
  ): zio.aws.route53recoverycontrolconfig.model.ControlPanel.ReadOnly =
    new Wrapper(impl)
}
