package zio.aws.route53recoverycontrolconfig.model
import zio.aws.route53recoverycontrolconfig.model.primitives.{
  __stringMin0Max256PatternS,
  __string,
  __stringMin1Max256PatternAZaZ09,
  __stringMin1Max64PatternS
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateControlPanelRequest(
    clientToken: Option[__stringMin1Max64PatternS] = None,
    clusterArn: __stringMin1Max256PatternAZaZ09,
    controlPanelName: __stringMin1Max64PatternS,
    tags: Option[Map[__string, __stringMin0Max256PatternS]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53recoverycontrolconfig.model.CreateControlPanelRequest = {
    import CreateControlPanelRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53recoverycontrolconfig.model.CreateControlPanelRequest
      .builder()
      .optionallyWith(
        clientToken.map(value =>
          __stringMin1Max64PatternS.unwrap(value): java.lang.String
        )
      )(_.clientToken)
      .clusterArn(
        __stringMin1Max256PatternAZaZ09.unwrap(clusterArn): java.lang.String
      )
      .controlPanelName(
        __stringMin1Max64PatternS.unwrap(controlPanelName): java.lang.String
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (__string
                .unwrap(key): java.lang.String) -> (__stringMin0Max256PatternS
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.route53recoverycontrolconfig.model.CreateControlPanelRequest.ReadOnly =
    zio.aws.route53recoverycontrolconfig.model.CreateControlPanelRequest
      .wrap(buildAwsValue())
}
object CreateControlPanelRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53recoverycontrolconfig.model.CreateControlPanelRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.route53recoverycontrolconfig.model.CreateControlPanelRequest =
      zio.aws.route53recoverycontrolconfig.model.CreateControlPanelRequest(
        clientToken.map(value => value),
        clusterArn,
        controlPanelName,
        tags.map(value => value)
      )
    def clientToken: Option[__stringMin1Max64PatternS]
    def clusterArn: __stringMin1Max256PatternAZaZ09
    def controlPanelName: __stringMin1Max64PatternS
    def tags: Option[Map[__string, __stringMin0Max256PatternS]]
    def getClientToken: ZIO[Any, AwsError, __stringMin1Max64PatternS] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getClusterArn: ZIO[Any, Nothing, __stringMin1Max256PatternAZaZ09] =
      ZIO.succeed(clusterArn)
    def getControlPanelName: ZIO[Any, Nothing, __stringMin1Max64PatternS] =
      ZIO.succeed(controlPanelName)
    def getTags: ZIO[Any, AwsError, Map[__string, __stringMin0Max256PatternS]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53recoverycontrolconfig.model.CreateControlPanelRequest
  ) extends zio.aws.route53recoverycontrolconfig.model.CreateControlPanelRequest.ReadOnly {
    override val clientToken: Option[__stringMin1Max64PatternS] = scala
      .Option(impl.clientToken())
      .map(value =>
        zio.aws.route53recoverycontrolconfig.model.primitives
          .__stringMin1Max64PatternS(value)
      )
    override val clusterArn: __stringMin1Max256PatternAZaZ09 =
      zio.aws.route53recoverycontrolconfig.model.primitives
        .__stringMin1Max256PatternAZaZ09(impl.clusterArn())
    override val controlPanelName: __stringMin1Max64PatternS =
      zio.aws.route53recoverycontrolconfig.model.primitives
        .__stringMin1Max64PatternS(impl.controlPanelName())
    override val tags: Option[Map[__string, __stringMin0Max256PatternS]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.route53recoverycontrolconfig.model.primitives.__string(
              key
            ) -> zio.aws.route53recoverycontrolconfig.model.primitives
              .__stringMin0Max256PatternS(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53recoverycontrolconfig.model.CreateControlPanelRequest
  ): zio.aws.route53recoverycontrolconfig.model.CreateControlPanelRequest.ReadOnly =
    new Wrapper(impl)
}
