package zio.aws.route53recoverycontrolconfig
import zio.aws.route53recoverycontrolconfig.model.ListAssociatedRoute53HealthChecksResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, ZManaged, IO, ZIO, ZLayer}
import software.amazon.awssdk.services.route53recoverycontrolconfig.{
  Route53RecoveryControlConfigAsyncClientBuilder,
  Route53RecoveryControlConfigAsyncClient
}
import zio.aws.route53recoverycontrolconfig.model.primitives.__stringMax36PatternS
import zio.aws.route53recoverycontrolconfig.model.{
  DeleteSafetyRuleRequest,
  DescribeControlPanelRequest,
  CreateControlPanelRequest,
  UpdateSafetyRuleRequest,
  UpdateRoutingControlRequest,
  ListTagsForResourceRequest,
  DeleteControlPanelRequest,
  UpdateControlPanelRequest,
  CreateClusterRequest,
  ListRoutingControlsRequest,
  DeleteClusterRequest,
  ListAssociatedRoute53HealthChecksRequest,
  ListSafetyRulesRequest,
  CreateRoutingControlRequest,
  UntagResourceRequest,
  ListControlPanelsRequest,
  DescribeSafetyRuleRequest,
  DescribeClusterRequest,
  DescribeRoutingControlRequest,
  ListClustersRequest,
  TagResourceRequest,
  CreateSafetyRuleRequest,
  DeleteRoutingControlRequest
}
import zio.stream.ZStream
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.{
  CreateSafetyRuleResponse,
  ListRoutingControlsResponse,
  Cluster,
  DescribeRoutingControlResponse,
  DescribeControlPanelResponse,
  DescribeSafetyRuleResponse,
  DescribeClusterResponse,
  ListTagsForResourceResponse,
  UntagResourceResponse,
  DeleteControlPanelResponse,
  ListSafetyRulesResponse,
  CreateClusterResponse,
  UpdateSafetyRuleResponse,
  ListAssociatedRoute53HealthChecksResponse,
  Rule,
  CreateControlPanelResponse,
  ListControlPanelsResponse,
  DeleteClusterResponse,
  DeleteRoutingControlResponse,
  ControlPanel,
  DeleteSafetyRuleResponse,
  TagResourceResponse,
  RoutingControl,
  CreateRoutingControlResponse,
  UpdateControlPanelResponse,
  UpdateRoutingControlResponse,
  ListClustersResponse
}
import scala.jdk.CollectionConverters.*
trait Route53RecoveryControlConfig
    extends AspectSupport[Route53RecoveryControlConfig] {
  val api: Route53RecoveryControlConfigAsyncClient
  def describeSafetyRule(request: DescribeSafetyRuleRequest): IO[
    AwsError,
    zio.aws.route53recoverycontrolconfig.model.DescribeSafetyRuleResponse.ReadOnly
  ]
  def updateSafetyRule(request: UpdateSafetyRuleRequest): IO[
    AwsError,
    zio.aws.route53recoverycontrolconfig.model.UpdateSafetyRuleResponse.ReadOnly
  ]
  def listControlPanels(request: ListControlPanelsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.route53recoverycontrolconfig.model.ControlPanel.ReadOnly
  ]
  def listControlPanelsPaginated(request: ListControlPanelsRequest): IO[
    AwsError,
    zio.aws.route53recoverycontrolconfig.model.ListControlPanelsResponse.ReadOnly
  ]
  def describeControlPanel(request: DescribeControlPanelRequest): IO[
    AwsError,
    zio.aws.route53recoverycontrolconfig.model.DescribeControlPanelResponse.ReadOnly
  ]
  def deleteRoutingControl(request: DeleteRoutingControlRequest): IO[
    AwsError,
    zio.aws.route53recoverycontrolconfig.model.DeleteRoutingControlResponse.ReadOnly
  ]
  def createRoutingControl(request: CreateRoutingControlRequest): IO[
    AwsError,
    zio.aws.route53recoverycontrolconfig.model.CreateRoutingControlResponse.ReadOnly
  ]
  def createCluster(request: CreateClusterRequest): IO[
    AwsError,
    zio.aws.route53recoverycontrolconfig.model.CreateClusterResponse.ReadOnly
  ]
  def deleteCluster(request: DeleteClusterRequest): IO[
    AwsError,
    zio.aws.route53recoverycontrolconfig.model.DeleteClusterResponse.ReadOnly
  ]
  def createSafetyRule(request: CreateSafetyRuleRequest): IO[
    AwsError,
    zio.aws.route53recoverycontrolconfig.model.CreateSafetyRuleResponse.ReadOnly
  ]
  def listSafetyRules(request: ListSafetyRulesRequest): ZStream[
    Any,
    AwsError,
    zio.aws.route53recoverycontrolconfig.model.Rule.ReadOnly
  ]
  def listSafetyRulesPaginated(request: ListSafetyRulesRequest): IO[
    AwsError,
    zio.aws.route53recoverycontrolconfig.model.ListSafetyRulesResponse.ReadOnly
  ]
  def listRoutingControls(request: ListRoutingControlsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.route53recoverycontrolconfig.model.RoutingControl.ReadOnly
  ]
  def listRoutingControlsPaginated(request: ListRoutingControlsRequest): IO[
    AwsError,
    zio.aws.route53recoverycontrolconfig.model.ListRoutingControlsResponse.ReadOnly
  ]
  def listAssociatedRoute53HealthChecks(
      request: ListAssociatedRoute53HealthChecksRequest
  ): ZStream[Any, AwsError, __stringMax36PatternS]
  def listAssociatedRoute53HealthChecksPaginated(
      request: ListAssociatedRoute53HealthChecksRequest
  ): IO[AwsError, ReadOnly]
  def untagResource(request: UntagResourceRequest): IO[
    AwsError,
    zio.aws.route53recoverycontrolconfig.model.UntagResourceResponse.ReadOnly
  ]
  def describeRoutingControl(request: DescribeRoutingControlRequest): IO[
    AwsError,
    zio.aws.route53recoverycontrolconfig.model.DescribeRoutingControlResponse.ReadOnly
  ]
  def describeCluster(request: DescribeClusterRequest): IO[
    AwsError,
    zio.aws.route53recoverycontrolconfig.model.DescribeClusterResponse.ReadOnly
  ]
  def listTagsForResource(request: ListTagsForResourceRequest): IO[
    AwsError,
    zio.aws.route53recoverycontrolconfig.model.ListTagsForResourceResponse.ReadOnly
  ]
  def listClusters(request: ListClustersRequest): ZStream[
    Any,
    AwsError,
    zio.aws.route53recoverycontrolconfig.model.Cluster.ReadOnly
  ]
  def listClustersPaginated(request: ListClustersRequest): IO[
    AwsError,
    zio.aws.route53recoverycontrolconfig.model.ListClustersResponse.ReadOnly
  ]
  def tagResource(request: TagResourceRequest): IO[
    AwsError,
    zio.aws.route53recoverycontrolconfig.model.TagResourceResponse.ReadOnly
  ]
  def updateControlPanel(request: UpdateControlPanelRequest): IO[
    AwsError,
    zio.aws.route53recoverycontrolconfig.model.UpdateControlPanelResponse.ReadOnly
  ]
  def createControlPanel(request: CreateControlPanelRequest): IO[
    AwsError,
    zio.aws.route53recoverycontrolconfig.model.CreateControlPanelResponse.ReadOnly
  ]
  def deleteSafetyRule(request: DeleteSafetyRuleRequest): IO[
    AwsError,
    zio.aws.route53recoverycontrolconfig.model.DeleteSafetyRuleResponse.ReadOnly
  ]
  def deleteControlPanel(request: DeleteControlPanelRequest): IO[
    AwsError,
    zio.aws.route53recoverycontrolconfig.model.DeleteControlPanelResponse.ReadOnly
  ]
  def updateRoutingControl(request: UpdateRoutingControlRequest): IO[
    AwsError,
    zio.aws.route53recoverycontrolconfig.model.UpdateRoutingControlResponse.ReadOnly
  ]
}
object Route53RecoveryControlConfig {
  val live
      : ZLayer[AwsConfig, java.lang.Throwable, Route53RecoveryControlConfig] =
    customized(identity)
  def customized(
      customization: Route53RecoveryControlConfigAsyncClientBuilder => Route53RecoveryControlConfigAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, Route53RecoveryControlConfig] =
    managed(customization).toLayer
  def managed(
      customization: Route53RecoveryControlConfigAsyncClientBuilder => Route53RecoveryControlConfigAsyncClientBuilder
  ): ZManaged[AwsConfig, java.lang.Throwable, Route53RecoveryControlConfig] =
    for (
      awsConfig <- ZManaged.service[AwsConfig];
      executor <- ZIO.executor.toManaged;
      builder = Route53RecoveryControlConfigAsyncClient
        .builder()
        .asyncConfiguration(
          software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
            .builder()
            .advancedOption(
              software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
              executor.asJava
            )
            .build()
        );
      b0 <- awsConfig
        .configure[
          Route53RecoveryControlConfigAsyncClient,
          Route53RecoveryControlConfigAsyncClientBuilder
        ](builder)
        .toManaged;
      b1 <- awsConfig
        .configureHttpClient[
          Route53RecoveryControlConfigAsyncClient,
          Route53RecoveryControlConfigAsyncClientBuilder
        ](
          b0,
          zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
        )
        .toManaged; client <- zio.ZIO(customization(b1).build()).toManaged
    )
      yield new Route53RecoveryControlConfigImpl(
        client,
        AwsCallAspect.identity,
        ZEnvironment.empty
      )
  private class Route53RecoveryControlConfigImpl[R](
      override val api: Route53RecoveryControlConfigAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends Route53RecoveryControlConfig
      with AwsServiceBase[R] {
    override val serviceName: String = "Route53RecoveryControlConfig"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): Route53RecoveryControlConfigImpl[R1] =
      new Route53RecoveryControlConfigImpl(api, newAspect, r)
    def describeSafetyRule(request: DescribeSafetyRuleRequest): IO[
      AwsError,
      zio.aws.route53recoverycontrolconfig.model.DescribeSafetyRuleResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53recoverycontrolconfig.model.DescribeSafetyRuleRequest,
      DescribeSafetyRuleResponse
    ]("describeSafetyRule", api.describeSafetyRule)(request.buildAwsValue())
      .map(
        zio.aws.route53recoverycontrolconfig.model.DescribeSafetyRuleResponse.wrap
      )
      .provideEnvironment(r)
    def updateSafetyRule(request: UpdateSafetyRuleRequest): IO[
      AwsError,
      zio.aws.route53recoverycontrolconfig.model.UpdateSafetyRuleResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53recoverycontrolconfig.model.UpdateSafetyRuleRequest,
      UpdateSafetyRuleResponse
    ]("updateSafetyRule", api.updateSafetyRule)(request.buildAwsValue())
      .map(
        zio.aws.route53recoverycontrolconfig.model.UpdateSafetyRuleResponse.wrap
      )
      .provideEnvironment(r)
    def listControlPanels(request: ListControlPanelsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.route53recoverycontrolconfig.model.ControlPanel.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListControlPanelsRequest,
      ListControlPanelsResponse,
      ControlPanel
    ](
      "listControlPanels",
      api.listControlPanels,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.controlPanels().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.route53recoverycontrolconfig.model.ControlPanel.wrap(item)
      )
      .provideEnvironment(r)
    def listControlPanelsPaginated(request: ListControlPanelsRequest): IO[
      AwsError,
      zio.aws.route53recoverycontrolconfig.model.ListControlPanelsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListControlPanelsRequest,
      ListControlPanelsResponse
    ]("listControlPanels", api.listControlPanels)(request.buildAwsValue())
      .map(
        zio.aws.route53recoverycontrolconfig.model.ListControlPanelsResponse.wrap
      )
      .provideEnvironment(r)
    def describeControlPanel(request: DescribeControlPanelRequest): IO[
      AwsError,
      zio.aws.route53recoverycontrolconfig.model.DescribeControlPanelResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53recoverycontrolconfig.model.DescribeControlPanelRequest,
      DescribeControlPanelResponse
    ]("describeControlPanel", api.describeControlPanel)(request.buildAwsValue())
      .map(
        zio.aws.route53recoverycontrolconfig.model.DescribeControlPanelResponse.wrap
      )
      .provideEnvironment(r)
    def deleteRoutingControl(request: DeleteRoutingControlRequest): IO[
      AwsError,
      zio.aws.route53recoverycontrolconfig.model.DeleteRoutingControlResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53recoverycontrolconfig.model.DeleteRoutingControlRequest,
      DeleteRoutingControlResponse
    ]("deleteRoutingControl", api.deleteRoutingControl)(request.buildAwsValue())
      .map(
        zio.aws.route53recoverycontrolconfig.model.DeleteRoutingControlResponse.wrap
      )
      .provideEnvironment(r)
    def createRoutingControl(request: CreateRoutingControlRequest): IO[
      AwsError,
      zio.aws.route53recoverycontrolconfig.model.CreateRoutingControlResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53recoverycontrolconfig.model.CreateRoutingControlRequest,
      CreateRoutingControlResponse
    ]("createRoutingControl", api.createRoutingControl)(request.buildAwsValue())
      .map(
        zio.aws.route53recoverycontrolconfig.model.CreateRoutingControlResponse.wrap
      )
      .provideEnvironment(r)
    def createCluster(request: CreateClusterRequest): IO[
      AwsError,
      zio.aws.route53recoverycontrolconfig.model.CreateClusterResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53recoverycontrolconfig.model.CreateClusterRequest,
      CreateClusterResponse
    ]("createCluster", api.createCluster)(request.buildAwsValue())
      .map(
        zio.aws.route53recoverycontrolconfig.model.CreateClusterResponse.wrap
      )
      .provideEnvironment(r)
    def deleteCluster(request: DeleteClusterRequest): IO[
      AwsError,
      zio.aws.route53recoverycontrolconfig.model.DeleteClusterResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53recoverycontrolconfig.model.DeleteClusterRequest,
      DeleteClusterResponse
    ]("deleteCluster", api.deleteCluster)(request.buildAwsValue())
      .map(
        zio.aws.route53recoverycontrolconfig.model.DeleteClusterResponse.wrap
      )
      .provideEnvironment(r)
    def createSafetyRule(request: CreateSafetyRuleRequest): IO[
      AwsError,
      zio.aws.route53recoverycontrolconfig.model.CreateSafetyRuleResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53recoverycontrolconfig.model.CreateSafetyRuleRequest,
      CreateSafetyRuleResponse
    ]("createSafetyRule", api.createSafetyRule)(request.buildAwsValue())
      .map(
        zio.aws.route53recoverycontrolconfig.model.CreateSafetyRuleResponse.wrap
      )
      .provideEnvironment(r)
    def listSafetyRules(request: ListSafetyRulesRequest): ZStream[
      Any,
      AwsError,
      zio.aws.route53recoverycontrolconfig.model.Rule.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListSafetyRulesRequest,
      ListSafetyRulesResponse,
      Rule
    ](
      "listSafetyRules",
      api.listSafetyRules,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.safetyRules().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.route53recoverycontrolconfig.model.Rule.wrap(item))
      .provideEnvironment(r)
    def listSafetyRulesPaginated(request: ListSafetyRulesRequest): IO[
      AwsError,
      zio.aws.route53recoverycontrolconfig.model.ListSafetyRulesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListSafetyRulesRequest,
      ListSafetyRulesResponse
    ]("listSafetyRules", api.listSafetyRules)(request.buildAwsValue())
      .map(
        zio.aws.route53recoverycontrolconfig.model.ListSafetyRulesResponse.wrap
      )
      .provideEnvironment(r)
    def listRoutingControls(request: ListRoutingControlsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.route53recoverycontrolconfig.model.RoutingControl.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListRoutingControlsRequest,
      ListRoutingControlsResponse,
      RoutingControl
    ](
      "listRoutingControls",
      api.listRoutingControls,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.routingControls().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.route53recoverycontrolconfig.model.RoutingControl.wrap(item)
      )
      .provideEnvironment(r)
    def listRoutingControlsPaginated(request: ListRoutingControlsRequest): IO[
      AwsError,
      zio.aws.route53recoverycontrolconfig.model.ListRoutingControlsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListRoutingControlsRequest,
      ListRoutingControlsResponse
    ]("listRoutingControls", api.listRoutingControls)(request.buildAwsValue())
      .map(
        zio.aws.route53recoverycontrolconfig.model.ListRoutingControlsResponse.wrap
      )
      .provideEnvironment(r)
    def listAssociatedRoute53HealthChecks(
        request: ListAssociatedRoute53HealthChecksRequest
    ): ZStream[Any, AwsError, __stringMax36PatternS] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListAssociatedRoute53HealthChecksRequest,
        ListAssociatedRoute53HealthChecksResponse,
        java.lang.String
      ](
        "listAssociatedRoute53HealthChecks",
        api.listAssociatedRoute53HealthChecks,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.healthCheckIds().asScala)
      )(request.buildAwsValue())
        .map(item =>
          zio.aws.route53recoverycontrolconfig.model.primitives
            .__stringMax36PatternS(item)
        )
        .provideEnvironment(r)
    def listAssociatedRoute53HealthChecksPaginated(
        request: ListAssociatedRoute53HealthChecksRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListAssociatedRoute53HealthChecksRequest,
      ListAssociatedRoute53HealthChecksResponse
    ](
      "listAssociatedRoute53HealthChecks",
      api.listAssociatedRoute53HealthChecks
    )(request.buildAwsValue())
      .map(
        zio.aws.route53recoverycontrolconfig.model.ListAssociatedRoute53HealthChecksResponse.wrap
      )
      .provideEnvironment(r)
    def untagResource(request: UntagResourceRequest): IO[
      AwsError,
      zio.aws.route53recoverycontrolconfig.model.UntagResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53recoverycontrolconfig.model.UntagResourceRequest,
      UntagResourceResponse
    ]("untagResource", api.untagResource)(request.buildAwsValue())
      .map(
        zio.aws.route53recoverycontrolconfig.model.UntagResourceResponse.wrap
      )
      .provideEnvironment(r)
    def describeRoutingControl(request: DescribeRoutingControlRequest): IO[
      AwsError,
      zio.aws.route53recoverycontrolconfig.model.DescribeRoutingControlResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53recoverycontrolconfig.model.DescribeRoutingControlRequest,
      DescribeRoutingControlResponse
    ]("describeRoutingControl", api.describeRoutingControl)(
      request.buildAwsValue()
    ).map(
      zio.aws.route53recoverycontrolconfig.model.DescribeRoutingControlResponse.wrap
    ).provideEnvironment(r)
    def describeCluster(request: DescribeClusterRequest): IO[
      AwsError,
      zio.aws.route53recoverycontrolconfig.model.DescribeClusterResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53recoverycontrolconfig.model.DescribeClusterRequest,
      DescribeClusterResponse
    ]("describeCluster", api.describeCluster)(request.buildAwsValue())
      .map(
        zio.aws.route53recoverycontrolconfig.model.DescribeClusterResponse.wrap
      )
      .provideEnvironment(r)
    def listTagsForResource(request: ListTagsForResourceRequest): IO[
      AwsError,
      zio.aws.route53recoverycontrolconfig.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(
        zio.aws.route53recoverycontrolconfig.model.ListTagsForResourceResponse.wrap
      )
      .provideEnvironment(r)
    def listClusters(request: ListClustersRequest): ZStream[
      Any,
      AwsError,
      zio.aws.route53recoverycontrolconfig.model.Cluster.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListClustersRequest,
      ListClustersResponse,
      Cluster
    ](
      "listClusters",
      api.listClusters,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.clusters().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.route53recoverycontrolconfig.model.Cluster.wrap(item)
      )
      .provideEnvironment(r)
    def listClustersPaginated(request: ListClustersRequest): IO[
      AwsError,
      zio.aws.route53recoverycontrolconfig.model.ListClustersResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListClustersRequest,
      ListClustersResponse
    ]("listClusters", api.listClusters)(request.buildAwsValue())
      .map(zio.aws.route53recoverycontrolconfig.model.ListClustersResponse.wrap)
      .provideEnvironment(r)
    def tagResource(request: TagResourceRequest): IO[
      AwsError,
      zio.aws.route53recoverycontrolconfig.model.TagResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53recoverycontrolconfig.model.TagResourceRequest,
      TagResourceResponse
    ]("tagResource", api.tagResource)(request.buildAwsValue())
      .map(zio.aws.route53recoverycontrolconfig.model.TagResourceResponse.wrap)
      .provideEnvironment(r)
    def updateControlPanel(request: UpdateControlPanelRequest): IO[
      AwsError,
      zio.aws.route53recoverycontrolconfig.model.UpdateControlPanelResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53recoverycontrolconfig.model.UpdateControlPanelRequest,
      UpdateControlPanelResponse
    ]("updateControlPanel", api.updateControlPanel)(request.buildAwsValue())
      .map(
        zio.aws.route53recoverycontrolconfig.model.UpdateControlPanelResponse.wrap
      )
      .provideEnvironment(r)
    def createControlPanel(request: CreateControlPanelRequest): IO[
      AwsError,
      zio.aws.route53recoverycontrolconfig.model.CreateControlPanelResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53recoverycontrolconfig.model.CreateControlPanelRequest,
      CreateControlPanelResponse
    ]("createControlPanel", api.createControlPanel)(request.buildAwsValue())
      .map(
        zio.aws.route53recoverycontrolconfig.model.CreateControlPanelResponse.wrap
      )
      .provideEnvironment(r)
    def deleteSafetyRule(request: DeleteSafetyRuleRequest): IO[
      AwsError,
      zio.aws.route53recoverycontrolconfig.model.DeleteSafetyRuleResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53recoverycontrolconfig.model.DeleteSafetyRuleRequest,
      DeleteSafetyRuleResponse
    ]("deleteSafetyRule", api.deleteSafetyRule)(request.buildAwsValue())
      .map(
        zio.aws.route53recoverycontrolconfig.model.DeleteSafetyRuleResponse.wrap
      )
      .provideEnvironment(r)
    def deleteControlPanel(request: DeleteControlPanelRequest): IO[
      AwsError,
      zio.aws.route53recoverycontrolconfig.model.DeleteControlPanelResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53recoverycontrolconfig.model.DeleteControlPanelRequest,
      DeleteControlPanelResponse
    ]("deleteControlPanel", api.deleteControlPanel)(request.buildAwsValue())
      .map(
        zio.aws.route53recoverycontrolconfig.model.DeleteControlPanelResponse.wrap
      )
      .provideEnvironment(r)
    def updateRoutingControl(request: UpdateRoutingControlRequest): IO[
      AwsError,
      zio.aws.route53recoverycontrolconfig.model.UpdateRoutingControlResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53recoverycontrolconfig.model.UpdateRoutingControlRequest,
      UpdateRoutingControlResponse
    ]("updateRoutingControl", api.updateRoutingControl)(request.buildAwsValue())
      .map(
        zio.aws.route53recoverycontrolconfig.model.UpdateRoutingControlResponse.wrap
      )
      .provideEnvironment(r)
  }
  def describeSafetyRule(request: DescribeSafetyRuleRequest): ZIO[
    zio.aws.route53recoverycontrolconfig.Route53RecoveryControlConfig,
    AwsError,
    zio.aws.route53recoverycontrolconfig.model.DescribeSafetyRuleResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeSafetyRule(request))
  def updateSafetyRule(request: UpdateSafetyRuleRequest): ZIO[
    zio.aws.route53recoverycontrolconfig.Route53RecoveryControlConfig,
    AwsError,
    zio.aws.route53recoverycontrolconfig.model.UpdateSafetyRuleResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateSafetyRule(request))
  def listControlPanels(request: ListControlPanelsRequest): ZStream[
    zio.aws.route53recoverycontrolconfig.Route53RecoveryControlConfig,
    AwsError,
    zio.aws.route53recoverycontrolconfig.model.ControlPanel.ReadOnly
  ] = ZStream.serviceWithStream(_.listControlPanels(request))
  def listControlPanelsPaginated(request: ListControlPanelsRequest): ZIO[
    zio.aws.route53recoverycontrolconfig.Route53RecoveryControlConfig,
    AwsError,
    zio.aws.route53recoverycontrolconfig.model.ListControlPanelsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listControlPanelsPaginated(request))
  def describeControlPanel(request: DescribeControlPanelRequest): ZIO[
    zio.aws.route53recoverycontrolconfig.Route53RecoveryControlConfig,
    AwsError,
    zio.aws.route53recoverycontrolconfig.model.DescribeControlPanelResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeControlPanel(request))
  def deleteRoutingControl(request: DeleteRoutingControlRequest): ZIO[
    zio.aws.route53recoverycontrolconfig.Route53RecoveryControlConfig,
    AwsError,
    zio.aws.route53recoverycontrolconfig.model.DeleteRoutingControlResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteRoutingControl(request))
  def createRoutingControl(request: CreateRoutingControlRequest): ZIO[
    zio.aws.route53recoverycontrolconfig.Route53RecoveryControlConfig,
    AwsError,
    zio.aws.route53recoverycontrolconfig.model.CreateRoutingControlResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createRoutingControl(request))
  def createCluster(request: CreateClusterRequest): ZIO[
    zio.aws.route53recoverycontrolconfig.Route53RecoveryControlConfig,
    AwsError,
    zio.aws.route53recoverycontrolconfig.model.CreateClusterResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createCluster(request))
  def deleteCluster(request: DeleteClusterRequest): ZIO[
    zio.aws.route53recoverycontrolconfig.Route53RecoveryControlConfig,
    AwsError,
    zio.aws.route53recoverycontrolconfig.model.DeleteClusterResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteCluster(request))
  def createSafetyRule(request: CreateSafetyRuleRequest): ZIO[
    zio.aws.route53recoverycontrolconfig.Route53RecoveryControlConfig,
    AwsError,
    zio.aws.route53recoverycontrolconfig.model.CreateSafetyRuleResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createSafetyRule(request))
  def listSafetyRules(request: ListSafetyRulesRequest): ZStream[
    zio.aws.route53recoverycontrolconfig.Route53RecoveryControlConfig,
    AwsError,
    zio.aws.route53recoverycontrolconfig.model.Rule.ReadOnly
  ] = ZStream.serviceWithStream(_.listSafetyRules(request))
  def listSafetyRulesPaginated(request: ListSafetyRulesRequest): ZIO[
    zio.aws.route53recoverycontrolconfig.Route53RecoveryControlConfig,
    AwsError,
    zio.aws.route53recoverycontrolconfig.model.ListSafetyRulesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listSafetyRulesPaginated(request))
  def listRoutingControls(request: ListRoutingControlsRequest): ZStream[
    zio.aws.route53recoverycontrolconfig.Route53RecoveryControlConfig,
    AwsError,
    zio.aws.route53recoverycontrolconfig.model.RoutingControl.ReadOnly
  ] = ZStream.serviceWithStream(_.listRoutingControls(request))
  def listRoutingControlsPaginated(request: ListRoutingControlsRequest): ZIO[
    zio.aws.route53recoverycontrolconfig.Route53RecoveryControlConfig,
    AwsError,
    zio.aws.route53recoverycontrolconfig.model.ListRoutingControlsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listRoutingControlsPaginated(request))
  def listAssociatedRoute53HealthChecks(
      request: ListAssociatedRoute53HealthChecksRequest
  ): ZStream[
    zio.aws.route53recoverycontrolconfig.Route53RecoveryControlConfig,
    AwsError,
    __stringMax36PatternS
  ] = ZStream.serviceWithStream(_.listAssociatedRoute53HealthChecks(request))
  def listAssociatedRoute53HealthChecksPaginated(
      request: ListAssociatedRoute53HealthChecksRequest
  ): ZIO[
    zio.aws.route53recoverycontrolconfig.Route53RecoveryControlConfig,
    AwsError,
    ReadOnly
  ] = ZIO.serviceWithZIO(_.listAssociatedRoute53HealthChecksPaginated(request))
  def untagResource(request: UntagResourceRequest): ZIO[
    zio.aws.route53recoverycontrolconfig.Route53RecoveryControlConfig,
    AwsError,
    zio.aws.route53recoverycontrolconfig.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def describeRoutingControl(request: DescribeRoutingControlRequest): ZIO[
    zio.aws.route53recoverycontrolconfig.Route53RecoveryControlConfig,
    AwsError,
    zio.aws.route53recoverycontrolconfig.model.DescribeRoutingControlResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeRoutingControl(request))
  def describeCluster(request: DescribeClusterRequest): ZIO[
    zio.aws.route53recoverycontrolconfig.Route53RecoveryControlConfig,
    AwsError,
    zio.aws.route53recoverycontrolconfig.model.DescribeClusterResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeCluster(request))
  def listTagsForResource(request: ListTagsForResourceRequest): ZIO[
    zio.aws.route53recoverycontrolconfig.Route53RecoveryControlConfig,
    AwsError,
    zio.aws.route53recoverycontrolconfig.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def listClusters(request: ListClustersRequest): ZStream[
    zio.aws.route53recoverycontrolconfig.Route53RecoveryControlConfig,
    AwsError,
    zio.aws.route53recoverycontrolconfig.model.Cluster.ReadOnly
  ] = ZStream.serviceWithStream(_.listClusters(request))
  def listClustersPaginated(request: ListClustersRequest): ZIO[
    zio.aws.route53recoverycontrolconfig.Route53RecoveryControlConfig,
    AwsError,
    zio.aws.route53recoverycontrolconfig.model.ListClustersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listClustersPaginated(request))
  def tagResource(request: TagResourceRequest): ZIO[
    zio.aws.route53recoverycontrolconfig.Route53RecoveryControlConfig,
    AwsError,
    zio.aws.route53recoverycontrolconfig.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def updateControlPanel(request: UpdateControlPanelRequest): ZIO[
    zio.aws.route53recoverycontrolconfig.Route53RecoveryControlConfig,
    AwsError,
    zio.aws.route53recoverycontrolconfig.model.UpdateControlPanelResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateControlPanel(request))
  def createControlPanel(request: CreateControlPanelRequest): ZIO[
    zio.aws.route53recoverycontrolconfig.Route53RecoveryControlConfig,
    AwsError,
    zio.aws.route53recoverycontrolconfig.model.CreateControlPanelResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createControlPanel(request))
  def deleteSafetyRule(request: DeleteSafetyRuleRequest): ZIO[
    zio.aws.route53recoverycontrolconfig.Route53RecoveryControlConfig,
    AwsError,
    zio.aws.route53recoverycontrolconfig.model.DeleteSafetyRuleResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteSafetyRule(request))
  def deleteControlPanel(request: DeleteControlPanelRequest): ZIO[
    zio.aws.route53recoverycontrolconfig.Route53RecoveryControlConfig,
    AwsError,
    zio.aws.route53recoverycontrolconfig.model.DeleteControlPanelResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteControlPanel(request))
  def updateRoutingControl(request: UpdateRoutingControlRequest): ZIO[
    zio.aws.route53recoverycontrolconfig.Route53RecoveryControlConfig,
    AwsError,
    zio.aws.route53recoverycontrolconfig.model.UpdateRoutingControlResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateRoutingControl(request))
}
